/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.source.scheduler;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.source.SchedulerConfiguration;
import org.mule.runtime.api.source.SchedulerMessageSource;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.source.scheduler.PeriodicScheduler;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.component.ComponentUtils;
import org.mule.runtime.core.internal.execution.FlowProcessTemplate;
import org.mule.runtime.core.internal.execution.MessageProcessContext;
import org.mule.runtime.core.internal.execution.MessageProcessingManager;
import org.mule.runtime.core.internal.source.scheduler.SchedulerFlowProcessingTemplate;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchedulerMessageSource
extends AbstractComponent
implements MessageSource,
SchedulerMessageSource,
MuleContextAware,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSchedulerMessageSource.class);
    private final PeriodicScheduler scheduler;
    private final boolean disallowConcurrentExecution;
    private Scheduler pollingExecutor;
    private ScheduledFuture<?> schedulingJob;
    private Processor listener;
    private FlowConstruct flowConstruct;
    private MuleContext muleContext;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private MessageProcessingManager messageProcessingManager;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    private boolean started;
    private volatile boolean executing = false;
    private FlowProcessTemplate flowProcessingTemplate;
    private SchedulerProcessContext flowProcessContext;

    public DefaultSchedulerMessageSource(MuleContext muleContext, PeriodicScheduler scheduler, boolean disallowConcurrentExecution) {
        this.muleContext = muleContext;
        this.scheduler = scheduler;
        this.disallowConcurrentExecution = disallowConcurrentExecution;
    }

    public synchronized void start() throws MuleException {
        if (this.started) {
            return;
        }
        try {
            this.schedulingJob = ClassUtils.withContextClassLoader(this.muleContext.getExecutionClassLoader(), () -> this.scheduler.schedule(this.pollingExecutor, () -> this.run()));
            this.started = true;
        }
        catch (Exception ex) {
            this.stop();
            throw new CreateException(CoreMessages.failedToScheduleWork(), (Throwable)ex, (Object)this);
        }
    }

    public synchronized void stop() throws MuleException {
        if (!this.started) {
            return;
        }
        if (this.schedulingJob != null) {
            this.schedulingJob.cancel(false);
            this.schedulingJob = null;
        }
        this.started = false;
    }

    public void trigger() {
        this.pollingExecutor.execute(() -> ClassUtils.withContextClassLoader(this.muleContext.getExecutionClassLoader(), () -> this.poll()));
    }

    public boolean isStarted() {
        return this.started;
    }

    public SchedulerConfiguration getConfiguration() {
        return this.scheduler;
    }

    private final void run() {
        PrivilegedEvent.setCurrentEvent(null);
        if (this.muleContext.isPrimaryPollingInstance()) {
            this.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poll() {
        boolean execute = false;
        DefaultSchedulerMessageSource defaultSchedulerMessageSource = this;
        synchronized (defaultSchedulerMessageSource) {
            if (this.disallowConcurrentExecution && this.executing) {
                execute = false;
            } else {
                execute = true;
                this.executing = true;
            }
        }
        if (execute) {
            this.doPoll();
        } else {
            LOGGER.info("Flow '{}' is already running and 'disallowConcurrentExecution' is set to 'true'. Execution skipped.", (Object)this.getLocation().getRootContainerName());
        }
    }

    private void doPoll() {
        try {
            this.messageProcessingManager.processMessage(this.flowProcessingTemplate, this.flowProcessContext);
        }
        catch (Exception e) {
            this.muleContext.getExceptionListener().handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIsExecuting(boolean value) {
        DefaultSchedulerMessageSource defaultSchedulerMessageSource = this;
        synchronized (defaultSchedulerMessageSource) {
            this.executing = value;
        }
    }

    public void initialise() throws InitialisationException {
        ComponentUtils.getFromAnnotatedObject(this.componentLocator, this).ifPresent(flow -> {
            this.flowConstruct = flow;
        });
        this.flowProcessingTemplate = new SchedulerFlowProcessingTemplate(this.listener, Collections.emptyList(), this, this.featureFlaggingService);
        this.flowProcessContext = new SchedulerProcessContext();
        this.createScheduler();
    }

    public void dispose() {
        this.disposeScheduler();
    }

    private void createScheduler() throws InitialisationException {
        this.pollingExecutor = this.muleContext.getSchedulerService().cpuLightScheduler();
    }

    private void disposeScheduler() {
        if (this.pollingExecutor != null) {
            this.pollingExecutor.stop();
            this.pollingExecutor = null;
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void setListener(Processor listener) {
        this.listener = listener;
    }

    @Override
    public MessageSource.BackPressureStrategy getBackPressureStrategy() {
        return MessageSource.BackPressureStrategy.FAIL;
    }

    private class SchedulerProcessContext
    implements MessageProcessContext {
        private final MessagingExceptionResolver messagingExceptionResolver = new MessagingExceptionResolver(this.getMessageSource());

        private SchedulerProcessContext() {
        }

        @Override
        public MessageSource getMessageSource() {
            return DefaultSchedulerMessageSource.this;
        }

        @Override
        public Optional<TransactionConfig> getTransactionConfig() {
            return Optional.empty();
        }

        @Override
        public ClassLoader getExecutionClassLoader() {
            return DefaultSchedulerMessageSource.this.muleContext.getExecutionClassLoader();
        }

        @Override
        public ErrorTypeLocator getErrorTypeLocator() {
            return DefaultSchedulerMessageSource.this.errorTypeLocator;
        }

        @Override
        public MessagingExceptionResolver getMessagingExceptionResolver() {
            return this.messagingExceptionResolver;
        }

        @Override
        public FlowConstruct getFlowConstruct() {
            return DefaultSchedulerMessageSource.this.flowConstruct;
        }
    }
}

