/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.reactivestreams.Publisher;
import reactor.core.publisher.EmitterProcessor;

class DirectSink
implements Sink,
Disposable {
    private final AbstractProcessingStrategy.ReactorSink reactorSink;

    public DirectSink(Function<Publisher<CoreEvent>, Publisher<CoreEvent>> function, Consumer<CoreEvent> eventConsumer, int bufferSize) {
        EmitterProcessor emitterProcessor = EmitterProcessor.create((int)bufferSize);
        reactor.core.Disposable disposable = emitterProcessor.transform(function).doOnError(throwable -> {}).subscribe();
        this.reactorSink = new AbstractProcessingStrategy.DefaultReactorSink(emitterProcessor.sink(), millis -> disposable.dispose(), eventConsumer, bufferSize);
    }

    @Override
    public void accept(CoreEvent event) {
        this.reactorSink.accept(event);
    }

    @Override
    public BackPressureReason emit(CoreEvent event) {
        return this.reactorSink.emit(event);
    }

    public void dispose() {
        this.reactorSink.prepareDispose();
        this.reactorSink.dispose();
    }
}

