/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.core.internal.lock.InstanceLockGroup;
import org.mule.runtime.core.internal.lock.LockGroup;
import org.mule.runtime.core.internal.lock.SingleServerLockProvider;

public class ServerLockFactory
implements LockFactory,
Disposable {
    private LockGroup lockGroup = new InstanceLockGroup(new SingleServerLockProvider());

    public synchronized Lock createLock(String lockId) {
        return new LockAdapter(lockId, this.lockGroup);
    }

    public void dispose() {
        if (this.lockGroup != null) {
            this.lockGroup.dispose();
        }
    }

    private static class LockAdapter
    implements Lock {
        private final String lockId;
        private final LockGroup lockGroup;

        public LockAdapter(String lockId, LockGroup lockGroup) {
            this.lockId = lockId;
            this.lockGroup = lockGroup;
        }

        @Override
        public void lock() {
            this.lockGroup.lock(this.lockId);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.lockGroup.lockInterruptibly(this.lockId);
        }

        @Override
        public boolean tryLock() {
            return this.lockGroup.tryLock(this.lockId);
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.lockGroup.tryLock(this.lockId, timeout, timeUnit);
        }

        @Override
        public void unlock() {
            this.lockGroup.unlock(this.lockId);
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("Operation not supported by mule locks");
        }
    }
}

