/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.datetime;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.LocaleUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.el.datetime.Instant;

public abstract class AbstractInstant
implements Instant {
    protected Locale locale;
    protected Calendar calendar;
    protected static final DatatypeFactory datatypeFactory;

    public AbstractInstant(Calendar calendar, Locale locale) {
        this.calendar = calendar;
        this.locale = locale;
    }

    public AbstractInstant() {
        this.calendar = Calendar.getInstance(Locale.getDefault());
        this.locale = Locale.getDefault();
    }

    @Override
    public boolean isBefore(Instant date) {
        return this.calendar.before(date.toCalendar());
    }

    @Override
    public boolean isAfter(Instant date) {
        return this.calendar.after(date.toCalendar());
    }

    @Override
    public String format() {
        return this.toString();
    }

    @Override
    public String format(String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, this.locale);
        dateFormat.setTimeZone(this.calendar.getTimeZone());
        return dateFormat.format(this.calendar.getTime());
    }

    @Override
    public String getTimeZone() {
        return this.calendar.getTimeZone().getDisplayName(this.locale);
    }

    @Override
    public Instant withTimeZone(String newTimezone) {
        int currentOffset = this.calendar.getTimeZone().getOffset(this.calendar.getTimeInMillis());
        TimeZone timeZone = TimeZone.getTimeZone(newTimezone);
        int newOffset = timeZone.getOffset(this.calendar.getTimeInMillis());
        int diffOffset = currentOffset - newOffset;
        this.calendar.add(14, diffOffset);
        this.calendar.setTimeZone(timeZone);
        return this;
    }

    @Override
    public Instant changeTimeZone(String newTimezone) {
        this.calendar.get(0);
        this.calendar.setTimeZone(TimeZone.getTimeZone(newTimezone));
        return this;
    }

    @Override
    public Instant withLocale(String locale) {
        this.locale = LocaleUtils.toLocale((String)locale);
        Calendar newCalendar = Calendar.getInstance(this.calendar.getTimeZone(), this.locale);
        newCalendar.setTime(this.calendar.getTime());
        this.calendar = newCalendar;
        return this;
    }

    @Override
    public Calendar toCalendar() {
        return this.calendar;
    }

    @Override
    public Date toDate() {
        return this.calendar.getTime();
    }

    @Override
    public XMLGregorianCalendar toXMLCalendar() throws DatatypeConfigurationException {
        if (this.calendar instanceof GregorianCalendar) {
            return datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)this.calendar);
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)"org.mule.runtime.core.internal.el.datetime.DateTime.toXMLCalendar() does not support non-gregorian calendars."));
    }

    private int getTimeZoneOffset() {
        return this.calendar.get(15);
    }

    public int hashCode() {
        return Objects.hash(this.calendar.getTimeInMillis(), this.calendar.getFirstDayOfWeek(), this.calendar.getMinimalDaysInFirstWeek(), this.getTimeZoneOffset());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractInstant)) {
            return false;
        }
        AbstractInstant other = (AbstractInstant)obj;
        return this.calendar.getTimeInMillis() == other.calendar.getTimeInMillis() && this.calendar.getFirstDayOfWeek() == other.calendar.getFirstDayOfWeek() && this.calendar.getMinimalDaysInFirstWeek() == other.calendar.getMinimalDaysInFirstWeek() && this.getTimeZoneOffset() == other.getTimeZoneOffset();
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new Error(e);
        }
    }
}

