/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connectivity;

import java.util.Collection;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.connectivity.ConnectivityTestingStrategy;
import org.mule.runtime.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.ObjectNotFoundException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;

public class DefaultConnectivityTestingService
implements ConnectivityTestingService,
Initialisable {
    private ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    private Collection<ConnectivityTestingStrategy> connectivityTestingStrategies;
    private MuleContext muleContext;
    private ConfigurationComponentLocator locator;

    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Inject
    protected void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Inject
    public void setLocator(ConfigurationComponentLocator locator) {
        this.locator = locator;
    }

    public void initialise() throws InitialisationException {
        this.connectivityTestingStrategies = this.serviceRegistry.lookupProviders(ConnectivityTestingStrategy.class, Thread.currentThread().getContextClassLoader());
        for (ConnectivityTestingStrategy connectivityTestingStrategy : this.connectivityTestingStrategies) {
            try {
                this.muleContext.getInjector().inject(connectivityTestingStrategy);
            }
            catch (MuleException e) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("Could not initialise connectivity testing strategy of type " + connectivityTestingStrategy.getClass().getName())), (Throwable)e, (Initialisable)this);
            }
        }
    }

    public ConnectionValidationResult testConnection(Location location) {
        Object connectivityTestingObject = this.locator.find(location).orElseThrow(() -> new ObjectNotFoundException("No object found with path: " + location));
        for (ConnectivityTestingStrategy connectivityTestingStrategy : this.connectivityTestingStrategies) {
            if (!connectivityTestingStrategy.accepts(connectivityTestingObject)) continue;
            try {
                return connectivityTestingStrategy.testConnectivity(connectivityTestingObject);
            }
            catch (Exception e) {
                return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
            }
        }
        throw new UnsupportedConnectivityTestingObjectException(I18nMessageFactory.createStaticMessage((String)("Could not do connectivity testing over object of type " + connectivityTestingObject.getClass().getName())));
    }
}

