/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import org.mule.runtime.api.meta.NameableObject;
import org.mule.runtime.core.api.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ObjectUtils.class);

    public static String identityToShortString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return new StringBuilder(40).append(ClassUtils.getSimpleName(obj.getClass())).append('@').append(Integer.toHexString(System.identityHashCode(obj))).toString();
    }

    public static String getString(Object answer, String defaultValue) {
        if (answer != null) {
            return answer.toString();
        }
        return defaultValue;
    }

    public static boolean getBoolean(Object answer, Boolean defaultValue) {
        if (answer != null) {
            if (answer instanceof Boolean) {
                return (Boolean)answer;
            }
            if (answer instanceof String) {
                return Boolean.valueOf((String)answer);
            }
            if (answer instanceof Number) {
                Number n = (Number)answer;
                return n.intValue() > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (logger.isWarnEnabled()) {
                logger.warn("Value exists but cannot be converted to boolean: " + answer + ", returning default value: " + defaultValue);
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static byte getByte(Object answer, Byte defaultValue) {
        if (answer == null) {
            return defaultValue;
        }
        if (answer instanceof Number) {
            return ((Number)answer).byteValue();
        }
        if (answer instanceof String) {
            try {
                return Byte.valueOf((String)answer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Value exists but cannot be converted to byte: " + answer + ", returning default value: " + defaultValue);
        }
        return defaultValue;
    }

    public static short getShort(Object answer, Short defaultValue) {
        if (answer == null) {
            return defaultValue;
        }
        if (answer instanceof Number) {
            return ((Number)answer).shortValue();
        }
        if (answer instanceof String) {
            try {
                return Short.valueOf((String)answer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Value exists but cannot be converted to short: " + answer + ", returning default value: " + defaultValue);
        }
        return defaultValue;
    }

    public static int getInt(Object answer, Integer defaultValue) {
        if (answer == null) {
            return defaultValue;
        }
        if (answer instanceof Number) {
            return ((Number)answer).intValue();
        }
        if (answer instanceof String) {
            try {
                return Integer.valueOf((String)answer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Value exists but cannot be converted to int: " + answer + ", returning default value: " + defaultValue);
        }
        return defaultValue;
    }

    public static long getLong(Object answer, Long defaultValue) {
        if (answer == null) {
            return defaultValue;
        }
        if (answer instanceof Number) {
            return ((Number)answer).longValue();
        }
        if (answer instanceof String) {
            try {
                return Long.valueOf((String)answer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Value exists but cannot be converted to long: " + answer + ", returning default value: " + defaultValue);
        }
        return defaultValue;
    }

    public static float getFloat(Object answer, Float defaultValue) {
        if (answer == null) {
            return defaultValue.floatValue();
        }
        if (answer instanceof Number) {
            return ((Number)answer).floatValue();
        }
        if (answer instanceof String) {
            try {
                return Float.valueOf((String)answer).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Value exists but cannot be converted to float: " + answer + ", returning default value: " + defaultValue);
        }
        return defaultValue.floatValue();
    }

    public static double getDouble(Object answer, Double defaultValue) {
        if (answer == null) {
            return defaultValue;
        }
        if (answer instanceof Number) {
            return ((Number)answer).doubleValue();
        }
        if (answer instanceof String) {
            try {
                return Double.valueOf((String)answer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Value exists but cannot be converted to double: " + answer + ", returning default value: " + defaultValue);
        }
        return defaultValue;
    }

    public static String toString(Object obj) {
        return ObjectUtils.toString(obj, "");
    }

    public static String toString(Object obj, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        String str = obj.getClass().getName();
        if (obj instanceof NameableObject) {
            str = str + String.format(" '%s'", ((NameableObject)obj).getName());
        }
        return str;
    }

    private ObjectUtils() {
    }
}

