/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.exception;

import java.util.Objects;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;

public final class WildcardErrorTypeMatcher
implements ErrorTypeMatcher {
    public static String WILDCARD_TOKEN = "*";
    private final ComponentIdentifier errorTypeIdentifier;
    private boolean nameIsWildcard;
    private boolean namespaceIsWildcard;

    public WildcardErrorTypeMatcher(ComponentIdentifier errorTypeIdentifier) {
        this.errorTypeIdentifier = errorTypeIdentifier;
        this.nameIsWildcard = WILDCARD_TOKEN.equals(errorTypeIdentifier.getName());
        this.namespaceIsWildcard = WILDCARD_TOKEN.equals(errorTypeIdentifier.getNamespace());
    }

    @Override
    public boolean match(ErrorType errorType) {
        if (this.matchIdentifier(errorType) && this.matchNamespace(errorType)) {
            return true;
        }
        return !this.nameIsWildcard && this.isChild(errorType);
    }

    private boolean matchNamespace(ErrorType errorType) {
        if (this.namespaceIsWildcard) {
            return true;
        }
        return Objects.equals(this.errorTypeIdentifier.getNamespace(), errorType.getNamespace());
    }

    private boolean matchIdentifier(ErrorType errorType) {
        if (this.nameIsWildcard) {
            return true;
        }
        return Objects.equals(this.errorTypeIdentifier.getName(), errorType.getIdentifier());
    }

    private boolean isChild(ErrorType errorType) {
        ErrorType parentErrorType = errorType.getParentErrorType();
        return parentErrorType != null && this.match(parentErrorType);
    }
}

