/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.connection.tcp.TpcChannelClientConnectionAdapter;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientPingCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public final class HeartbeatManager {
    private HeartbeatManager() {
    }

    public static void start(HazelcastClientInstanceImpl client, TaskScheduler taskScheduler, ILogger logger, long heartbeatIntervalMillis, long heartbeatTimeoutMillis, Collection<ClientConnection> connectionsView) {
        HeartbeatChecker heartbeatChecker = new HeartbeatChecker(client, logger, heartbeatIntervalMillis, heartbeatTimeoutMillis, connectionsView);
        taskScheduler.scheduleWithRepetition(heartbeatChecker, heartbeatIntervalMillis, heartbeatIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private static final class HeartbeatChecker
    implements Runnable {
        private final HazelcastClientInstanceImpl client;
        private final ILogger logger;
        private final long heartbeatIntervalMillis;
        private final long heartbeatTimeoutMillis;
        private final Collection<ClientConnection> connectionsView;

        private HeartbeatChecker(HazelcastClientInstanceImpl client, ILogger logger, long heartbeatIntervalMillis, long heartbeatTimeoutMillis, Collection<ClientConnection> connectionsView) {
            this.client = client;
            this.heartbeatTimeoutMillis = heartbeatTimeoutMillis;
            this.heartbeatIntervalMillis = heartbeatIntervalMillis;
            this.connectionsView = connectionsView;
            this.logger = logger;
        }

        @Override
        public void run() {
            long now = Clock.currentTimeMillis();
            for (ClientConnection connection : this.connectionsView) {
                this.check(connection, now);
                Channel[] tpcChannels = connection.getTpcChannels();
                if (tpcChannels == null) continue;
                for (Channel tpcChannel : tpcChannels) {
                    this.check(tpcChannel, connection, now);
                }
            }
        }

        private void check(ClientConnection connection, long now) {
            if (!connection.isAlive()) {
                return;
            }
            if (now - connection.lastReadTimeMillis() > this.heartbeatTimeoutMillis) {
                this.logger.warning("Heartbeat failed over the connection: " + connection);
                connection.close("Heartbeat timed out", new TargetDisconnectedException("Heartbeat timed out to connection " + connection));
                return;
            }
            if (now - connection.lastWriteTimeMillis() > this.heartbeatIntervalMillis) {
                this.sendPing(connection);
            }
        }

        private void check(Channel tpcChannel, ClientConnection connection, long now) {
            if (tpcChannel.isClosed() || !connection.isAlive()) {
                return;
            }
            if (now - tpcChannel.lastReadTimeMillis() > this.heartbeatTimeoutMillis) {
                String message = "Heartbeat failed over the TPC channel: " + tpcChannel + " for connection: " + connection;
                this.logger.warning(message);
                connection.close("Heartbeat timed out", new TargetDisconnectedException(message));
                return;
            }
            if (now - tpcChannel.lastWriteTimeMillis() > this.heartbeatIntervalMillis) {
                ConcurrentMap attributeMap = tpcChannel.attributeMap();
                ClientConnection adapter = (ClientConnection)attributeMap.get(TpcChannelClientConnectionAdapter.class);
                this.sendPing(adapter);
            }
        }

        private void sendPing(ClientConnection connection) {
            ClientMessage request = ClientPingCodec.encodeRequest();
            ClientInvocation invocation = new ClientInvocation(this.client, request, null, connection);
            invocation.invokeUrgent();
        }
    }
}

