/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.internal.util.JarUtils;
import org.mule.runtime.module.deployment.impl.internal.maven.AbstractMavenClassLoaderModelLoader;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class MuleArtifactPatchingModel {
    private static Map<String, MuleArtifactPatchingModel> loadedModelByJAr = new HashMap<String, MuleArtifactPatchingModel>();
    private ArtifactCoordinates artifactCoordinates;
    private List<String> affectedVersions;

    static synchronized MuleArtifactPatchingModel loadModel(String jarFile) throws IOException {
        if (!loadedModelByJAr.containsKey(jarFile)) {
            File pluginPatchJarFile = new File(new File(MuleContainerBootstrapUtils.getMuleHome(), AbstractMavenClassLoaderModelLoader.MULE_ARTIFACT_PATCHES_LOCATION), jarFile);
            Optional muleArtifactPatchContent = JarUtils.loadFileContentFrom((File)pluginPatchJarFile, (String)"mule-artifact-patch.json");
            muleArtifactPatchContent.map(bytes -> {
                MuleArtifactPatchingModel artifactPatchingModel = MuleArtifactPatchingModel.deserialize(bytes);
                loadedModelByJAr.put(jarFile, artifactPatchingModel);
                return artifactPatchingModel;
            }).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid jar file %s. It does not contains descriptor %s", jarFile, "mule-artifact-patch.json"))));
        }
        return loadedModelByJAr.get(jarFile);
    }

    private static MuleArtifactPatchingModel deserialize(byte[] muleArtifactPatchBytes) {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
        MuleArtifactPatchingModel classLoaderModel = (MuleArtifactPatchingModel)gson.fromJson(new String(muleArtifactPatchBytes), MuleArtifactPatchingModel.class);
        return classLoaderModel;
    }

    public ArtifactCoordinates getArtifactCoordinates() {
        return this.artifactCoordinates;
    }

    public void setArtifactCoordinates(ArtifactCoordinates artifactCoordinates) {
        this.artifactCoordinates = artifactCoordinates;
    }

    public List<String> getAffectedVersions() {
        return this.affectedVersions;
    }

    public void setAffectedVersions(List<String> affectedVersions) {
        this.affectedVersions = affectedVersions;
    }
}

