/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import algebra.ring.Ring;
import algebra.ring.Rng;
import algebra.ring.Semiring;
import cats.kernel.Eq;
import scala.Function2;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import spire.algebra.Field;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Polynomial$mcD$sp;
import spire.math.poly.PolyDense;
import spire.math.poly.PolyDense$;
import spire.math.poly.PolySparse;

public class PolyDense$mcD$sp
extends PolyDense<Object>
implements Polynomial$mcD$sp {
    public final double[] coeffs$mcD$sp;

    @Override
    public double[] coeffs$mcD$sp() {
        return this.coeffs$mcD$sp;
    }

    public double[] coeffs() {
        return this.coeffs$mcD$sp();
    }

    @Override
    public PolySparse<Object> toSparse(Semiring<Object> ring, Eq<Object> eq) {
        return this.toSparse$mcD$sp(ring, eq);
    }

    @Override
    public PolySparse<Object> toSparse$mcD$sp(Semiring<Object> ring, Eq<Object> eq) {
        return Polynomial$.MODULE$.sparse$mDc$sp(this.data$mcD$sp(ring, eq), ring, eq, this.ct());
    }

    @Override
    public PolyDense<Object> toDense(Semiring<Object> ring, Eq<Object> eq) {
        return this.toDense$mcD$sp(ring, eq);
    }

    @Override
    public PolyDense<Object> toDense$mcD$sp(Semiring<Object> ring, Eq<Object> eq) {
        return this;
    }

    @Override
    public <U> void foreach(Function2<Object, Object, U> f) {
        this.foreach$mcD$sp(f);
    }

    @Override
    public <U> void foreach$mcD$sp(Function2<Object, Object, U> f) {
        for (int index$macro$510 = 0; index$macro$510 < this.coeffs().length; ++index$macro$510) {
            f.apply((Object)BoxesRunTime.boxToInteger((int)index$macro$510), (Object)BoxesRunTime.boxToDouble((double)this.coeffs()[index$macro$510]));
        }
    }

    @Override
    public <U> void foreachNonZero(Function2<Object, Object, U> f, Semiring<Object> ring, Eq<Object> eq) {
        this.foreachNonZero$mcD$sp(f, ring, eq);
    }

    @Override
    public <U> void foreachNonZero$mcD$sp(Function2<Object, Object, U> f, Semiring<Object> ring, Eq<Object> eq) {
        for (int index$macro$511 = 0; index$macro$511 < this.coeffs().length; ++index$macro$511) {
            double c = this.coeffs()[index$macro$511];
            if (!eq.neqv$mcD$sp(c, ring.zero$mcD$sp())) continue;
            f.apply((Object)BoxesRunTime.boxToInteger((int)index$macro$511), (Object)BoxesRunTime.boxToDouble((double)c));
        }
    }

    public double[] coeffsArray(Semiring<Object> ring) {
        return this.coeffsArray$mcD$sp(ring);
    }

    @Override
    public double[] coeffsArray$mcD$sp(Semiring<Object> ring) {
        return this.coeffs();
    }

    @Override
    public double nth(int n, Semiring<Object> ring) {
        return this.nth$mcD$sp(n, ring);
    }

    @Override
    public double nth$mcD$sp(int n, Semiring<Object> ring) {
        return n < this.coeffs().length ? this.coeffs()[n] : ring.zero$mcD$sp();
    }

    @Override
    public double maxOrderTermCoeff(Semiring<Object> ring) {
        return this.maxOrderTermCoeff$mcD$sp(ring);
    }

    @Override
    public double maxOrderTermCoeff$mcD$sp(Semiring<Object> ring) {
        return this.isZero() ? ring.zero$mcD$sp() : this.coeffs()[this.degree()];
    }

    @Override
    public Polynomial<Object> reductum(Eq<Object> e, Semiring<Object> ring, ClassTag<Object> ct) {
        return this.reductum$mcD$sp(e, ring, ct);
    }

    @Override
    public Polynomial<Object> reductum$mcD$sp(Eq<Object> e, Semiring<Object> ring, ClassTag<Object> ct) {
        PolyDense$mcD$sp polyDense$mcD$sp;
        int i;
        for (i = this.coeffs().length - 2; i >= 0 && e.eqv$mcD$sp(this.coeffs()[i], ring.zero$mcD$sp()); --i) {
        }
        if (i < 0) {
            polyDense$mcD$sp = new PolyDense$mcD$sp((double[])ct.newArray(0), ct);
        } else {
            double[] arr = (double[])ct.newArray(i + 1);
            System.arraycopy(this.coeffs(), 0, arr, 0, i + 1);
            polyDense$mcD$sp = new PolyDense$mcD$sp(arr, ct);
        }
        return polyDense$mcD$sp;
    }

    @Override
    public double apply(double x, Semiring<Object> ring) {
        return this.apply$mcD$sp(x, ring);
    }

    @Override
    public double apply$mcD$sp(double x, Semiring<Object> ring) {
        double d;
        if (this.isZero()) {
            return ring.zero$mcD$sp();
        }
        int even = this.coeffs().length - 1;
        int odd = this.coeffs().length - 2;
        if ((even & 1) == 1) {
            even = odd;
            odd = this.coeffs().length - 1;
        }
        double c0 = this.coeffs()[even];
        double x2 = ring.pow$mcD$sp(x, 2);
        for (int index$macro$512 = even - 2; index$macro$512 >= 0; index$macro$512 -= 2) {
            c0 = ring.plus$mcD$sp(this.coeffs()[index$macro$512], ring.times$mcD$sp(c0, x2));
        }
        if (odd >= 1) {
            double c1 = this.coeffs()[odd];
            for (int index$macro$513 = odd - 2; index$macro$513 >= 1; index$macro$513 -= 2) {
                c1 = ring.plus$mcD$sp(this.coeffs()[index$macro$513], ring.times$mcD$sp(c1, x2));
            }
            d = ring.plus$mcD$sp(c0, ring.times$mcD$sp(c1, x));
        } else {
            d = c0;
        }
        return d;
    }

    @Override
    public Polynomial<Object> derivative(Ring<Object> ring, Eq<Object> eq) {
        return this.derivative$mcD$sp(ring, eq);
    }

    @Override
    public Polynomial<Object> derivative$mcD$sp(Ring<Object> ring, Eq<Object> eq) {
        if (this.isZero()) {
            return this;
        }
        double[] cs = (double[])this.ct().newArray(this.degree());
        int j = this.coeffs().length - 1;
        for (int index$macro$514 = cs.length - 1; index$macro$514 >= 0; --index$macro$514) {
            cs[index$macro$514] = ring.times$mcD$sp(ring.fromInt$mcD$sp(j), this.coeffs()[j]);
            --j;
        }
        return Polynomial$.MODULE$.dense$mDc$sp(cs, (Semiring<Object>)ring, eq, (ClassTag<Object>)this.ct());
    }

    @Override
    public Polynomial<Object> integral(Field<Object> field, Eq<Object> eq) {
        return this.integral$mcD$sp(field, eq);
    }

    @Override
    public Polynomial<Object> integral$mcD$sp(Field<Object> field, Eq<Object> eq) {
        double[] cs = (double[])this.ct().newArray(this.coeffs().length + 1);
        cs[0] = field.zero$mcD$sp();
        for (int index$macro$515 = 0; index$macro$515 < this.coeffs().length; ++index$macro$515) {
            cs[index$macro$515 + 1] = field.div$mcD$sp(this.coeffs()[index$macro$515], field.fromInt$mcD$sp(index$macro$515 + 1));
        }
        return Polynomial$.MODULE$.dense$mDc$sp(cs, (Semiring<Object>)field, eq, (ClassTag<Object>)this.ct());
    }

    @Override
    public Polynomial<Object> unary_$minus(Rng<Object> ring) {
        return this.unary_$minus$mcD$sp(ring);
    }

    @Override
    public Polynomial<Object> unary_$minus$mcD$sp(Rng<Object> ring) {
        double[] negArray = (double[])this.ct().newArray(this.coeffs().length);
        for (int index$macro$516 = 0; index$macro$516 < this.coeffs().length; ++index$macro$516) {
            negArray[index$macro$516] = ring.negate$mcD$sp(this.coeffs()[index$macro$516]);
        }
        return new PolyDense$mcD$sp(negArray, this.ct());
    }

    @Override
    public Polynomial<Object> $plus(Polynomial<Object> rhs, Semiring<Object> ring, Eq<Object> eq) {
        return this.$plus$mcD$sp(rhs, ring, eq);
    }

    @Override
    public Polynomial<Object> $plus$mcD$sp(Polynomial<Object> rhs, Semiring<Object> ring, Eq<Object> eq) {
        return PolyDense$.MODULE$.spire$math$poly$PolyDense$$plusDense(this, rhs, ring, eq, this.ct());
    }

    @Override
    public Polynomial<Object> $times(Polynomial<Object> rhs, Semiring<Object> ring, Eq<Object> eq) {
        return this.$times$mcD$sp(rhs, ring, eq);
    }

    @Override
    public Polynomial<Object> $times$mcD$sp(Polynomial<Object> rhs, Semiring<Object> ring, Eq<Object> eq) {
        if (rhs.isZero()) {
            return rhs;
        }
        if (this.isZero()) {
            return this;
        }
        double[] lcs = this.coeffsArray$mcD$sp(ring);
        double[] rcs = rhs.coeffsArray$mcD$sp(ring);
        double[] cs = (double[])this.ct().newArray(lcs.length + rcs.length - 1);
        for (int index$macro$517 = 0; index$macro$517 < cs.length; ++index$macro$517) {
            cs[index$macro$517] = ring.zero$mcD$sp();
        }
        for (int index$macro$519 = 0; index$macro$519 < lcs.length; ++index$macro$519) {
            double c = lcs[index$macro$519];
            int k = index$macro$519;
            for (int index$macro$518 = 0; index$macro$518 < rcs.length; ++index$macro$518) {
                int n = k++;
                cs[n] = ring.plus$mcD$sp(cs[n], ring.times$mcD$sp(c, rcs[index$macro$518]));
            }
        }
        return Polynomial$.MODULE$.dense$mDc$sp(cs, ring, eq, this.ct());
    }

    @Override
    public Polynomial<Object> $times$colon(double k, Semiring<Object> ring, Eq<Object> eq) {
        return this.$times$colon$mcD$sp(k, ring, eq);
    }

    @Override
    public Polynomial<Object> $times$colon$mcD$sp(double k, Semiring<Object> ring, Eq<Object> eq) {
        PolyDense<Object> polyDense;
        if (eq.eqv$mcD$sp(k, ring.zero$mcD$sp())) {
            polyDense = Polynomial$.MODULE$.dense$mDc$sp((double[])this.ct().newArray(0), ring, eq, this.ct());
        } else {
            double[] cs = (double[])this.ct().newArray(this.coeffs().length);
            for (int index$macro$520 = 0; index$macro$520 < cs.length; ++index$macro$520) {
                cs[index$macro$520] = ring.times$mcD$sp(k, this.coeffs()[index$macro$520]);
            }
            polyDense = Polynomial$.MODULE$.dense$mDc$sp(cs, ring, eq, this.ct());
        }
        return polyDense;
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public PolyDense$mcD$sp(double[] coeffs$mcD$sp, ClassTag<Object> ct) {
        this.coeffs$mcD$sp = coeffs$mcD$sp;
        super(null, ct);
    }
}

