/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.retry;

import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.backoff.scheduler.factory.VariableExecutorBackoffSchedulerFactory;
import com.mulesoft.anypoint.retry.BackoffRunnableRetrier;
import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import org.mule.runtime.api.lifecycle.Disposable;

public class BackoffRunnableRetrierFactory
implements Disposable {
    public static final String PLATFORM_CONNECTION_RETRIER_NAME = "agw-api-platform-connection-retry";
    public static final String POLICY_SET_DEPLOYMENT_SERVICE_RETRIER_NAME = "agw-policy-set-deployment";
    public static final String API_TRACKER_RETRIER_NAME = "agw-api-tracking-retry";
    private final GatewayConfiguration gatewayConfiguration;
    private BackoffRunnableRetrier<String> platformConnectionRetrier;
    private BackoffRunnableRetrier<ApiKey> policySetDeploymentServiceRetrier;
    private BackoffRunnableRetrier<ApiKey> apiTracker;

    public BackoffRunnableRetrierFactory(GatewayConfiguration gatewayConfiguration) {
        this.gatewayConfiguration = gatewayConfiguration;
    }

    public RunnableRetrier<String> platformConnectionRetrier() {
        if (this.platformConnectionRetrier == null) {
            this.platformConnectionRetrier = new BackoffRunnableRetrier.Builder(PLATFORM_CONNECTION_RETRIER_NAME, this.gatewayConfiguration.platformClient().getOutagesStatusCodes(), this.gatewayConfiguration.platformClient().backoffEnabled().booleanValue()).scheduler((BackoffSchedulerFactory)this.schedulerFactory(), BackoffRunnableRetrier.delayInitialScheduling((int)this.gatewayConfiguration.platformClient().getPlatformInitializationRetryFrequency())).build();
        }
        return this.platformConnectionRetrier;
    }

    public RunnableRetrier<ApiKey> policySetDeploymentServiceRetrier() {
        if (this.policySetDeploymentServiceRetrier == null) {
            this.policySetDeploymentServiceRetrier = new BackoffRunnableRetrier.Builder(POLICY_SET_DEPLOYMENT_SERVICE_RETRIER_NAME, this.gatewayConfiguration.platformClient().getOutagesStatusCodes(), this.gatewayConfiguration.platformClient().backoffEnabled().booleanValue()).retryUntilNewSchedule().scheduler((BackoffSchedulerFactory)this.schedulerFactory(), BackoffRunnableRetrier.zeroDelayOnScheduling()).build();
        }
        return this.policySetDeploymentServiceRetrier;
    }

    public RunnableRetrier<ApiKey> apiTrackerRetrier() {
        if (this.apiTracker == null) {
            this.apiTracker = new BackoffRunnableRetrier.Builder(API_TRACKER_RETRIER_NAME, this.gatewayConfiguration.platformClient().getOutagesStatusCodes(), this.gatewayConfiguration.platformClient().backoffEnabled().booleanValue()).scheduler((BackoffSchedulerFactory)this.schedulerFactory(), BackoffRunnableRetrier.delayInitialScheduling((int)this.gatewayConfiguration.platformClient().getPlatformInitializationRetryFrequency())).build();
        }
        return this.apiTracker;
    }

    private VariableExecutorBackoffSchedulerFactory schedulerFactory() {
        return new VariableExecutorBackoffSchedulerFactory();
    }

    public void dispose() {
        if (this.apiTracker != null) {
            this.apiTracker.dispose();
        }
        if (this.policySetDeploymentServiceRetrier != null) {
            this.policySetDeploymentServiceRetrier.dispose();
        }
        if (this.platformConnectionRetrier != null) {
            this.platformConnectionRetrier.dispose();
        }
    }
}

