/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.queue;

import com.mulesoft.mule.runtime.gw.queue.DefaultSizeLimitedQueue;
import com.mulesoft.mule.runtime.gw.queue.QueueLimitReachedStrategy;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueueFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Function;

public class SizeLimitedPartitionedQueue<T>
extends DefaultSizeLimitedQueue<T> {
    private final SizeLimitedQueueFactory queueFactory = new SizeLimitedQueueFactory();
    private final long partitionLimit;
    private final Function<T, String> partitioner;
    private final Map<String, SizeLimitedQueue<T>> partitions = new HashMap<String, SizeLimitedQueue<T>>();

    SizeLimitedPartitionedQueue(Queue<T> queue, long queueLimit, long partitionLimit, Function<T, String> partitioner, QueueLimitReachedStrategy<T> limitReachedStrategy) {
        super(queue, limitReachedStrategy, queueLimit);
        this.partitioner = partitioner;
        this.partitionLimit = partitionLimit;
    }

    @Override
    public boolean add(T element) {
        String key = this.partitioner.apply(element);
        SizeLimitedQueue partition = this.partitions.computeIfAbsent(key, s -> this.queueFactory.createCircularQueue(this.queue, this.partitionLimit));
        return partition.hasCapacity() && (this.hasCapacity() ? partition.add(element) : this.limitReachedStrategy.onLimitReached(this, element));
    }

    @Override
    public Optional<T> retrieve() {
        Optional element = Optional.ofNullable(this.queue.peek());
        if (element.isPresent()) {
            String key = this.partitioner.apply(element.get());
            this.partitions.get(key).retrieve();
            this.removePartitionIfEmpty(key);
        }
        return element;
    }

    @Override
    public int size() {
        return this.partitions.values().stream().map(SizeLimitedQueue::size).reduce((x, y) -> x + y).orElse(0);
    }

    @Override
    public void clear() {
        this.partitions.values().forEach(SizeLimitedQueue::clear);
        this.partitions.clear();
    }

    private void removePartitionIfEmpty(String key) {
        if (this.partitions.get(key).isEmpty()) {
            this.partitions.remove(key);
        }
    }
}

