/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.DefaultGatekeeperStatusTracker;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatusTracker;
import java.util.Optional;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.policy.PolicyRegistrationException;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.artifact.api.Artifact;

public class ApiImplementation {
    private static final String DEFAULT_DOMAIN_NAME = "default";
    private ApiKey apiKey;
    private Application application;
    private Flow flow;
    private GatekeeperStatusTracker status;
    private final String hdpService;
    private final boolean ignoreBasePathOnResourceLevel;

    public ApiImplementation(ApiKey apiKey, Application application, Flow flow, boolean ignoreBasePathOnResourceLevel) {
        this(apiKey, application, flow, null, ignoreBasePathOnResourceLevel);
    }

    public ApiImplementation(ApiKey apiKey, Application application, Flow flow, String hdpService, boolean ignoreBasePathOnResourceLevel) {
        this.apiKey = apiKey;
        this.application = application;
        this.flow = flow;
        this.ignoreBasePathOnResourceLevel = ignoreBasePathOnResourceLevel;
        this.status = new DefaultGatekeeperStatusTracker();
        this.hdpService = hdpService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolicy(PolicyTemplateDescriptor templateDescriptor, PolicyParametrization policyParametrization) throws PolicyRegistrationException {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getArtifactClassloader());
        try {
            this.application.getPolicyManager().addPolicy(templateDescriptor, policyParametrization);
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    public boolean removePolicy(String policyName) {
        return (Boolean)ClassUtils.withContextClassLoader((ClassLoader)this.getArtifactClassloader(), () -> this.application.getPolicyManager().removePolicy(policyName));
    }

    public Flow getFlow() {
        return this.flow;
    }

    public String getArtifactName() {
        return this.application.getArtifactName();
    }

    public ApiKey getApiKey() {
        return this.apiKey;
    }

    public ClassLoader getArtifactClassloader() {
        return this.application.getArtifactClassLoader().getClassLoader();
    }

    public GatekeeperStatusTracker gatekeeperStatus() {
        return this.status;
    }

    public Optional<String> getHdpService() {
        return Optional.ofNullable(this.hdpService);
    }

    public boolean isHdp() {
        return this.hdpService != null;
    }

    public boolean isIgnoreBasePathOnResourceLevel() {
        return this.ignoreBasePathOnResourceLevel;
    }

    public String getDomainName() {
        return Optional.ofNullable(this.application.getDomain()).map(Artifact::getArtifactName).orElse(DEFAULT_DOMAIN_NAME);
    }
}

