/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.metrics.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.mulesoft.mule.runtime.gw.metrics.event.ApiDeployed;
import com.mulesoft.mule.runtime.gw.metrics.event.ApiUndeployed;
import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.metrics.event.EventVisitor;
import com.mulesoft.mule.runtime.gw.metrics.event.PolicyApplied;
import com.mulesoft.mule.runtime.gw.metrics.event.PolicyRemoved;
import com.mulesoft.mule.runtime.gw.metrics.event.information.GatewayInformation;
import com.mulesoft.mule.runtime.gw.metrics.event.status.GatewayStatus;
import com.mulesoft.mule.runtime.gw.metrics.serialization.dto.ApiDeployedDto;
import com.mulesoft.mule.runtime.gw.metrics.serialization.dto.ApiUndeployedDto;
import com.mulesoft.mule.runtime.gw.metrics.serialization.dto.EventDto;
import com.mulesoft.mule.runtime.gw.metrics.serialization.dto.EventMetadata;
import com.mulesoft.mule.runtime.gw.metrics.serialization.dto.GatewayInformationDto;
import com.mulesoft.mule.runtime.gw.metrics.serialization.dto.GatewayStatusDto;
import com.mulesoft.mule.runtime.gw.metrics.serialization.dto.PolicyAppliedDto;
import com.mulesoft.mule.runtime.gw.metrics.serialization.dto.PolicyRemovedDto;
import java.util.List;
import java.util.stream.Collectors;

public class EventMapper
implements EventVisitor<EventDto> {
    private final EventMetadata metadata;
    private final ObjectWriter writer = new ObjectMapper().writerFor((TypeReference)new TypeReference<List<EventDto>>(){});

    public EventMapper(String uuid, String orgId) {
        this.metadata = new EventMetadata(uuid, orgId);
    }

    public String serialize(List<Event> events) throws JsonProcessingException {
        List collect = events.stream().map(event -> event.accept(this)).collect(Collectors.toList());
        return this.writer.writeValueAsString(collect);
    }

    @Override
    public EventDto visit(ApiDeployed apiDeployed) {
        return new ApiDeployedDto(this.metadata, apiDeployed);
    }

    @Override
    public EventDto visit(ApiUndeployed apiUndeployed) {
        return new ApiUndeployedDto(this.metadata, apiUndeployed);
    }

    @Override
    public EventDto visit(GatewayInformation gatewayInformation) {
        return new GatewayInformationDto(this.metadata, gatewayInformation);
    }

    @Override
    public EventDto visit(GatewayStatus gatewayStatus) {
        return new GatewayStatusDto(this.metadata, gatewayStatus);
    }

    @Override
    public EventDto visit(PolicyApplied policyApplied) {
        return new PolicyAppliedDto(this.metadata, policyApplied);
    }

    @Override
    public EventDto visit(PolicyRemoved policyRemoved) {
        return new PolicyRemovedDto(this.metadata, policyRemoved);
    }
}

