/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml;

import com.google.common.base.Throwables;
import java.io.File;
import java.util.Optional;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.raml.BaseRamlTypeLoader;
import org.mule.metadata.raml.RamlModelBuilderFactory;
import org.mule.metadata.raml.handler.ParsingContext;
import org.mule.metadata.raml.handler.TypeDeclarationHandlerManager;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class DataTypeRamlFragmentTypeLoader
extends BaseRamlTypeLoader {
    private final RamlLoader ramlLoader;
    private MetadataFormat metadataFormat;

    public DataTypeRamlFragmentTypeLoader(File file, MetadataFormat metadataFormat) {
        this.ramlLoader = new FileRamlLoader(file);
        this.metadataFormat = metadataFormat;
    }

    public DataTypeRamlFragmentTypeLoader(String content, MetadataFormat metadataFormat) {
        this.ramlLoader = new StringRamlLoader(content);
        this.metadataFormat = metadataFormat;
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        try {
            RamlModelResult ramlModelResult = this.ramlLoader.load();
            TypeDeclaration typeDeclaration = ramlModelResult.getTypeDeclaration();
            if (typeDeclaration == null) {
                String validationErrors = this.collectValidationErrors(ramlModelResult);
                throw new IllegalArgumentException(validationErrors);
            }
            TypeDeclarationHandlerManager typeDeclarationHandlerManager = new TypeDeclarationHandlerManager(this.metadataFormat);
            TypeBuilder<?> typeBuilder = typeDeclarationHandlerManager.handle(typeDeclaration, new ParsingContext());
            MetadataTypeUtils.addTypeAlias(typeBuilder, (String)typeAlias);
            return Optional.of(typeBuilder.build());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class StringRamlLoader
    implements RamlLoader {
        private final String content;

        public StringRamlLoader(String content) {
            this.content = content;
        }

        @Override
        public RamlModelResult load() {
            return RamlModelBuilderFactory.INSTANCE.createRamlModelBuilder().buildApi(this.content, "");
        }
    }

    private static class FileRamlLoader
    implements RamlLoader {
        private final File ramlFile;

        public FileRamlLoader(File ramlFile) {
            this.ramlFile = ramlFile;
        }

        @Override
        public RamlModelResult load() {
            return RamlModelBuilderFactory.INSTANCE.createRamlModelBuilder().buildApi(this.ramlFile);
        }
    }

    private static interface RamlLoader {
        public RamlModelResult load();
    }
}

