/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.ioc.ObjectProvider;
import org.mule.runtime.config.internal.MuleArtifactContext;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

class MuleArtifactObjectProvider
extends AbstractComponent
implements ObjectProvider {
    private final MuleArtifactContext muleArtifactContext;

    MuleArtifactObjectProvider(MuleArtifactContext muleArtifactContext) {
        this.muleArtifactContext = muleArtifactContext;
    }

    public Optional<Object> getObject(String name) {
        try {
            if (!this.muleArtifactContext.containsBeanDefinition(name)) {
                return Optional.empty();
            }
            Object bean = this.muleArtifactContext.getBean(name);
            return Optional.of(bean);
        }
        catch (NoSuchBeanDefinitionException e) {
            return Optional.empty();
        }
    }

    public Optional<Object> getObjectByType(Class<?> objectType) {
        try {
            Object bean = this.muleArtifactContext.getBean(objectType);
            return Optional.of(bean);
        }
        catch (NoSuchBeanDefinitionException e) {
            return Optional.empty();
        }
    }

    public Optional<Boolean> isObjectSingleton(String name) {
        try {
            return Optional.of(this.muleArtifactContext.isSingleton(name));
        }
        catch (NoSuchBeanDefinitionException e) {
            return Optional.empty();
        }
    }

    public boolean containsObject(String name) {
        return this.muleArtifactContext.containsBean(name);
    }

    public <T> Map<String, T> getObjectsByType(Class<T> type) {
        return this.muleArtifactContext.getBeansOfType(type);
    }
}

