/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.template.resolver;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateResolverException;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.PolicyTemplateResolver;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class HandlebarsPolicyTemplateResolver
implements PolicyTemplateResolver {
    private static final String EQUALS_HELPER = "equals";
    private final Handlebars handlebars = new Handlebars();

    public HandlebarsPolicyTemplateResolver() {
        this.handlebars.prettyPrint(true);
        this.handlebars.registerHelper(EQUALS_HELPER, (value, options) -> Objects.equals(value, options.param(0)));
    }

    @Override
    public String resolve(PolicyTemplate policyTemplate, Map<String, Object> configurationData) throws PolicyTemplateResolverException {
        try {
            StringTemplateSource templateSource = new StringTemplateSource(policyTemplate.getKey().getName(), FileUtils.readFileToString((File)policyTemplate.getTemplateFile()));
            Template template = this.handlebars.compile((TemplateSource)templateSource);
            return template.apply(configurationData);
        }
        catch (Exception e) {
            throw new PolicyTemplateResolverException("Unexpected error resolving policy template " + policyTemplate.getKey().getName(), e);
        }
    }
}

