/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.encrypter;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedValueResult;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.PolicyTypeEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.filter.StringListTypeFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ListOfStringsEncrypter
extends PolicyTypeEncrypter<List<String>> {
    public ListOfStringsEncrypter(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled, List<PolicyProperty> policyProperties) {
        super(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties);
    }

    @Override
    protected EncryptedValueResult encryptSingle(String key, List<String> values) {
        HashMap<String, String> configFile = new HashMap<String, String>();
        ArrayList<String> templateList = new ArrayList<String>();
        ArrayList<String> configData = new ArrayList<String>();
        for (int i = 0; i < values.size(); ++i) {
            String replacementKey = String.join((CharSequence)"", key, ".", String.valueOf(i));
            String templateValue = String.join((CharSequence)"", "${secure::", replacementKey, "}");
            templateList.add(templateValue);
            String encrypted = this.encrypt(values.get(i));
            configFile.put(String.valueOf(i), encrypted);
            configData.add(encrypted);
        }
        return new EncryptedValueResult(key, templateList, configData, configFile);
    }

    @Override
    protected EncryptedValueResult decryptSingle(String key, List<String> value) {
        List decrypted = value.stream().map(this::decrypt).collect(Collectors.toList());
        return new EncryptedValueResult(key, decrypted, decrypted);
    }

    @Override
    protected boolean supports(String key, Optional<PolicyProperty> property) {
        return property.isPresent() && new StringListTypeFilter().test(property.get());
    }
}

