/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.tracking;

import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTracker;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import org.mule.runtime.api.lifecycle.Disposable;

public class RetriableApiTracker
implements ApiDeploymentListener,
Disposable {
    private final RunnableRetrier<ApiKey> runnableRetrier;
    private final ApiTracker apiTacker;

    public RetriableApiTracker(ApiTracker apiTracker, RunnableRetrier<ApiKey> runnableRetrier) {
        this.apiTacker = apiTracker;
        this.runnableRetrier = runnableRetrier;
    }

    public void onApiDeploymentSuccess(Api api) {
        try {
            this.apiTacker.onApiDeploymentSuccess(api);
        }
        catch (Throwable t) {
            this.scheduleRetry(api);
        }
    }

    private void scheduleRetry(Api api) {
        this.runnableRetrier.scheduleRetry((Object)api.getKey(), () -> this.onApiDeploymentSuccess(api));
    }

    public void dispose() {
        this.runnableRetrier.dispose();
    }
}

