/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.replication;

import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.replication.ApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.MapDBContractRepository;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StandaloneApiConfigurationCache
implements ApiConfigurationCache {
    private Map<ApiKey, PolicySet> policySets = new HashMap<ApiKey, PolicySet>();
    private PolicySetDeploymentService policySetDeploymentService;
    private ContractRepository contractRepository;

    public StandaloneApiConfigurationCache(PolicySetDeploymentService policySetDeploymentService) {
        this.policySetDeploymentService = policySetDeploymentService;
        this.contractRepository = new MapDBContractRepository();
    }

    @Override
    public void set(ApiKey apiKey, PolicySet policySet, List<Sla> slas) {
        this.policySets.put(apiKey, policySet);
    }

    @Override
    public void remove(ApiKey apiKey) {
        this.policySets.remove(apiKey);
    }

    @Override
    public Optional<PolicySet> getPolicies(ApiKey apiKey) {
        if (this.policySets.containsKey(apiKey)) {
            return Optional.ofNullable(this.policySets.get(apiKey));
        }
        return this.contractRepository.containsSla(apiKey) ? Optional.of(this.emptySet()) : Optional.empty();
    }

    @Override
    public void initialise(ApiTrackingService apiTrackingService) {
        this.policySetDeploymentService.storedOnlinePoliciesByApi().forEach((apiKey, policyDefinitions) -> this.policySets.put((ApiKey)apiKey, new PolicySet(policyDefinitions, PolicySet.PolicySetOrigin.FILE_SYSTEM)));
    }

    private PolicySet emptySet() {
        return new PolicySet(Collections.emptyList(), PolicySet.PolicySetOrigin.FILE_SYSTEM);
    }
}

