/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.quorum;

import com.mulesoft.mule.runtime.gw.api.config.QuorumConfiguration;
import com.mulesoft.mule.runtime.gw.retry.FixedRetrier;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import com.mulesoft.mule.runtime.module.cluster.internal.lock.HazelcastLockProvider;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class ClusterReadyRetrier {
    private static final String CLUSTER_READY_DEFER_NAME = "agw-cluster-ready-defer";
    private static final String CLUSTER_LOCK_CHECK_NAME = "cluster-ready-check";
    private final FixedRetrier clusterReadyRetrier;
    private final HazelcastClusterManager hazelcastManager;

    public ClusterReadyRetrier(QuorumConfiguration quorumConfiguration, HazelcastClusterManager hazelcastManager) {
        this.hazelcastManager = hazelcastManager;
        this.clusterReadyRetrier = new FixedRetrier((long)quorumConfiguration.delaySeconds(), TimeUnit.SECONDS);
    }

    public void deferTillClusterReady(Runnable runnable) {
        this.clusterReadyRetrier.tryOrReschedule(CLUSTER_READY_DEFER_NAME, () -> {
            this.checkClusterReady();
            runnable.run();
        });
    }

    public void dispose() {
        this.clusterReadyRetrier.dispose();
    }

    private void checkClusterReady() {
        if (this.hazelcastManager == null) {
            return;
        }
        Lock lock = new HazelcastLockProvider(this.hazelcastManager.getClusterId(), this.hazelcastManager.getHazelcastInstance(), "gw").createLock(CLUSTER_LOCK_CHECK_NAME);
        try {
            lock.lock();
        }
        finally {
            lock.unlock();
        }
    }
}

