/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.flatfile;

import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.formats.GeneralStringFormat;
import com.mulesoft.flatfile.schema.fftypes.BooleanFormat;
import com.mulesoft.flatfile.schema.fftypes.DecimalFormat;
import com.mulesoft.flatfile.schema.fftypes.IntegerFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalDateFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalDateTimeFormat;
import com.mulesoft.flatfile.schema.fftypes.LocalTimeFormat;
import com.mulesoft.flatfile.schema.fftypes.StringFormat;
import com.mulesoft.flatfile.schema.model.Copybook$;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.EdiForm$;
import com.mulesoft.flatfile.schema.model.EdiFormConverter;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.FixedWidth$;
import com.mulesoft.flatfile.schema.model.FlatFile$;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import com.mulesoft.flatfile.schema.yaml.YamlReader$;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.mule.flatfile.metadata.schema.FieldAnnotationFactory;
import org.mule.flatfile.metadata.schema.SegmentHandler;
import org.mule.flatfile.metadata.schema.StructureHandler;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.flatfile.FieldFormatAnnotation;
import org.mule.metadata.flatfile.SchemaConstructAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class FlatfileTypeLoader
implements TypeLoader {
    public static final MetadataFormat FLAT_FILE = new MetadataFormat("Flatfile", "flatfile", new String[]{"application/flatfile"});
    public static final MetadataFormat COPYBOOK = new MetadataFormat("Copybook", "copybook", new String[]{"application/flatfile"});
    public static final MetadataFormat FIXED_WIDTH = new MetadataFormat("FixedWidth", "fixedWidth", new String[]{"application/flatfile"});
    public static final String SCHEMA_PATH_PROPKEY = "schemaPath";
    public static final String STRUCTURE_IDENT_PROPKEY = "structureIdent";
    public static final String SEGMENT_IDENT_PROPKEY = "segmentIdent";
    protected static final Logger logger = LoggerFactory.getLogger(FlatfileTypeLoader.class);
    private static final java.util.Map<TypeFormatConstants.GenericType, FieldAnnotationFactory> fieldAnnotators = new HashMap<TypeFormatConstants.GenericType, FieldAnnotationFactory>();
    private final String schemaPath;
    private final String useFormat;
    private final EdiFormConverter formConverter;

    public FlatfileTypeLoader(String path, String format, EdiFormConverter formconv) {
        if (path == null) {
            throw new IllegalArgumentException("schema path cannot be null");
        }
        this.schemaPath = path;
        this.useFormat = format;
        this.formConverter = formconv;
    }

    public FlatfileTypeLoader(String path, String format) {
        this(path, format, (EdiFormConverter)EdiForm$.MODULE$);
    }

    public FlatfileTypeLoader(String path) {
        this(path, null);
    }

    public Optional<MetadataType> load(String identifier) {
        return this.load(identifier, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<MetadataType> load(String identifier, String typeAlias) {
        YamlReader.InputSource source = YamlReader$.MODULE$.findSchema(this.schemaPath);
        YamlReader yamlrdr = new YamlReader(this.formConverter);
        try (InputStreamReader inputStreamReader = new InputStreamReader(source.input());){
            MetadataFormat format;
            EdiSchema schema = yamlrdr.loadYaml((Reader)inputStreamReader, source.prefixPaths(), false);
            EdiForm form = schema.ediVersion().ediForm();
            java.util.Map<Object, Object> fieldAnnos = Collections.emptyMap();
            if (FlatFile$.MODULE$ == form) {
                format = FLAT_FILE;
            } else if (FixedWidth$.MODULE$ == form) {
                format = FIXED_WIDTH;
            } else {
                if (Copybook$.MODULE$ != form) throw new IllegalArgumentException("Incompatible schema type " + form.text() + " for flat file metadata generation");
                format = COPYBOOK;
            }
            if (format == FIXED_WIDTH) {
                fieldAnnos = fieldAnnotators;
            }
            boolean done = false;
            ObjectTypeBuilder typeBuilder = null;
            SchemaConstructAnnotation.SchemaConstruct construct = null;
            java.util.Map structures = JavaConverters.mapAsJavaMap((Map)schema.structures());
            HashMap<String, String> props = new HashMap<String, String>();
            String relpath = this.schemaPath;
            try {
                URI baseuri = Thread.currentThread().getContextClassLoader().getResource("").toURI();
                URI relUri = baseuri.relativize(new File(this.schemaPath).toURI());
                relpath = relUri.isAbsolute() ? Paths.get(relUri).toFile().getAbsolutePath() : relUri.getPath();
            }
            catch (URISyntaxException e) {
                logger.error("Unable to relativize schemaPath " + this.schemaPath, (Throwable)e);
            }
            props.put(SCHEMA_PATH_PROPKEY, relpath);
            Structure structure = null;
            if (identifier == null && structures.size() == 1) {
                structure = (Structure)structures.values().iterator().next();
            } else {
                structure = (Structure)structures.get(identifier);
                if (structure != null) {
                    props.put(STRUCTURE_IDENT_PROPKEY, identifier);
                }
            }
            if (structure != null) {
                StructureHandler handler = new StructureHandler(format, form, fieldAnnos);
                ObjectTypeBuilder objectBuilder = new ObjectTypeBuilder(format);
                handler.buildStructure(structure, false, objectBuilder);
                typeBuilder = objectBuilder;
                construct = SchemaConstructAnnotation.SchemaConstruct.STRUCTURE;
                done = true;
            }
            if (!done) {
                java.util.Map segments = JavaConverters.mapAsJavaMap((Map)schema.segments());
                Segment segment = null;
                if (identifier == null && segments.size() == 1) {
                    segment = (Segment)segments.values().iterator().next();
                } else {
                    segment = (Segment)segments.get(identifier);
                    if (segment != null) {
                        props.put(SEGMENT_IDENT_PROPKEY, identifier);
                    }
                }
                if (segment == null) {
                    if (identifier != null) throw new IllegalArgumentException("Identifier " + identifier + " not found in schema");
                    throw new IllegalArgumentException("Structure or segment identifier needed for schema");
                }
                SegmentHandler handler = new SegmentHandler(form, format, fieldAnnos);
                BaseTypeBuilder baseBuilder = new BaseTypeBuilder(format);
                ObjectTypeBuilder objectBuilder = baseBuilder.objectType();
                typeBuilder = baseBuilder.arrayType().of((TypeBuilder)objectBuilder);
                handler.buildSegment(segment, objectBuilder);
                construct = SchemaConstructAnnotation.SchemaConstruct.SEGMENT;
            }
            MetadataTypeUtils.addTypeAlias(typeBuilder, (String)typeAlias);
            if (typeBuilder instanceof WithAnnotation) {
                WithAnnotation withanno = (WithAnnotation)typeBuilder;
                withanno.with((TypeAnnotation)new SchemaConstructAnnotation(construct));
                withanno.with((TypeAnnotation)new MetadataFormatPropertiesAnnotation(props));
            }
            Optional<MetadataType> optional = Optional.of(typeBuilder.build());
            return optional;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        fieldAnnotators.put(TypeFormatConstants.GenericType.STRING, new StringFieldFormatAnnotationFactory());
        fieldAnnotators.put(TypeFormatConstants.GenericType.INTEGER, new IntegerFieldFormatAnnotationFactory());
        fieldAnnotators.put(TypeFormatConstants.GenericType.REAL, new DecimalFieldFormatAnnotationFactory());
        fieldAnnotators.put(TypeFormatConstants.GenericType.BOOLEAN, new BooleanFieldFormatAnnotationFactory());
        fieldAnnotators.put(TypeFormatConstants.GenericType.DATE, new DateFieldFormatAnnotationFactory());
        fieldAnnotators.put(TypeFormatConstants.GenericType.DATETIME, new DateTimeFieldFormatAnnotationFactory());
    }

    private static final class DateTimeFieldFormatAnnotationFactory
    implements FieldAnnotationFactory {
        private DateTimeFieldFormatAnnotationFactory() {
        }

        public FieldFormatAnnotation create(TypeFormat format) {
            if (format instanceof LocalDateTimeFormat.LocalDateTimeFormatImpl) {
                LocalDateTimeFormat.LocalDateTimeFormatImpl formatter = (LocalDateTimeFormat.LocalDateTimeFormatImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withAlign(formatter.mode().name());
                return fieldFormatAnnotation;
            }
            if (format instanceof LocalDateTimeFormat.LocalDateTimePatternImpl) {
                LocalDateTimeFormat.LocalDateTimePatternImpl formatter = (LocalDateTimeFormat.LocalDateTimePatternImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withAlign(formatter.mode().name()).withPattern(formatter.pattern()).withLocale(formatter.toString());
                return fieldFormatAnnotation;
            }
            if (format instanceof LocalTimeFormat.LocalTimeFormatImpl) {
                LocalTimeFormat.LocalTimeFormatImpl formatter = (LocalTimeFormat.LocalTimeFormatImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withAlign(formatter.mode().name());
                return fieldFormatAnnotation;
            }
            if (format instanceof LocalTimeFormat.LocalTimePatternImpl) {
                LocalTimeFormat.LocalTimePatternImpl formatter = (LocalTimeFormat.LocalTimePatternImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withAlign(formatter.mode().name()).withPattern(formatter.pattern()).withLocale(formatter.toString());
                return fieldFormatAnnotation;
            }
            return null;
        }
    }

    private static final class DateFieldFormatAnnotationFactory
    implements FieldAnnotationFactory {
        private DateFieldFormatAnnotationFactory() {
        }

        public FieldFormatAnnotation create(TypeFormat format) {
            if (format instanceof LocalDateFormat.LocalDateFormatImpl) {
                LocalDateFormat.LocalDateFormatImpl formatter = (LocalDateFormat.LocalDateFormatImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withAlign(formatter.mode().name());
                return fieldFormatAnnotation;
            }
            if (format instanceof LocalDateFormat.LocalDatePatternImpl) {
                LocalDateFormat.LocalDatePatternImpl formatter = (LocalDateFormat.LocalDatePatternImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withAlign(formatter.mode().name()).withPattern(formatter.pattern()).withLocale(formatter.toString());
                return fieldFormatAnnotation;
            }
            return null;
        }
    }

    private static final class BooleanFieldFormatAnnotationFactory
    implements FieldAnnotationFactory {
        private BooleanFieldFormatAnnotationFactory() {
        }

        public FieldFormatAnnotation create(TypeFormat format) {
            BooleanFormat.BooleanFormatImpl formatter = (BooleanFormat.BooleanFormatImpl)format;
            FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
            fieldFormatAnnotation.withTrueRepresentation(formatter.t()).withFalseRepresentation(formatter.f()).withCaseSensitive(formatter.caseSensitive()).withAlign(formatter.mode().name());
            return fieldFormatAnnotation;
        }
    }

    private static final class DecimalFieldFormatAnnotationFactory
    implements FieldAnnotationFactory {
        private DecimalFieldFormatAnnotationFactory() {
        }

        public FieldFormatAnnotation create(TypeFormat format) {
            if (format instanceof DecimalFormat.DecimalFormatImpl) {
                DecimalFormat.DecimalFormatImpl formatter = (DecimalFormat.DecimalFormatImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withNumberSign(formatter.sign().name()).withAlign(formatter.mode().name());
                return fieldFormatAnnotation;
            }
            if (format instanceof DecimalFormat.DecimalImplicitImpl) {
                DecimalFormat.DecimalImplicitImpl formatter = (DecimalFormat.DecimalImplicitImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withImpliedDecimalDigits(formatter.impl()).withNumberSign(formatter.sign().name()).withAlign(formatter.mode().name());
                return fieldFormatAnnotation;
            }
            if (format instanceof DecimalFormat.DecimalPatternImpl) {
                DecimalFormat.DecimalPatternImpl formatter = (DecimalFormat.DecimalPatternImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withAlign(formatter.mode().name()).withPattern(formatter.pattern()).withLocale(formatter.locale().toString());
                return fieldFormatAnnotation;
            }
            return null;
        }
    }

    private static final class IntegerFieldFormatAnnotationFactory
    implements FieldAnnotationFactory {
        private IntegerFieldFormatAnnotationFactory() {
        }

        public FieldFormatAnnotation create(TypeFormat format) {
            if (format instanceof IntegerFormat.IntegerFormatImpl) {
                IntegerFormat.IntegerFormatImpl formatter = (IntegerFormat.IntegerFormatImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withNumberSign(formatter.sign().name()).withAlign(formatter.mode().name());
                return fieldFormatAnnotation;
            }
            if (format instanceof IntegerFormat.IntegerPatternImpl) {
                IntegerFormat.IntegerPatternImpl formatter = (IntegerFormat.IntegerPatternImpl)format;
                FieldFormatAnnotation fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withAlign(formatter.mode().name()).withPattern(formatter.pattern()).withLocale(formatter.locale().toString());
                return fieldFormatAnnotation;
            }
            return null;
        }
    }

    private static final class StringFieldFormatAnnotationFactory
    implements FieldAnnotationFactory {
        private StringFieldFormatAnnotationFactory() {
        }

        public FieldFormatAnnotation create(TypeFormat format) {
            FieldFormatAnnotation fieldFormatAnnotation;
            if (format instanceof StringFormat.StringFormatImpl) {
                StringFormat.StringFormatImpl formatter = (StringFormat.StringFormatImpl)format;
                fieldFormatAnnotation = new FieldFormatAnnotation(formatter.width());
                fieldFormatAnnotation.withAlign(formatter.mode().name());
            } else {
                GeneralStringFormat formatter = (GeneralStringFormat)format;
                fieldFormatAnnotation = new FieldFormatAnnotation(formatter.maxLength());
                fieldFormatAnnotation.withAlign(TypeFormatConstants.FillMode.NONE.name());
            }
            return fieldFormatAnnotation;
        }
    }
}

