/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.processor;

import com.mulesoft.mule.runtime.core.internal.processor.DynamicEvaluateProcessorParameters;
import com.mulesoft.mule.runtime.core.internal.processor.TransformMessageProcessor;
import javax.inject.Inject;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.privileged.util.AttributeEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoInstantiate
public final class DynamicEvaluateProcessor
extends AbstractComponent
implements Processor,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformMessageProcessor.class);
    @Inject
    private ExtendedExpressionManager expressionManager;
    private AttributeEvaluator expression;
    private DynamicEvaluateProcessorParameters parameters;
    private String target;
    private String targetValue = "#[payload]";
    private CompiledExpression targetValueExpression;

    public DynamicEvaluateProcessor(String expression) {
        this.expression = new AttributeEvaluator(expression, DataType.STRING);
    }

    public void initialise() throws InitialisationException {
        this.expression.initialize(this.expressionManager);
        Preconditions.checkArgument((boolean)this.expressionManager.isExpression(this.expression.getRawValue()), (String)"The 'script' must be an expression. Use transform processor for static scripts.");
        Preconditions.checkArgument((boolean)this.expressionManager.isExpression(this.targetValue), (String)"The 'targetValue' must be an expression.");
        if (this.parameters != null) {
            LifecycleUtils.initialiseIfNeeded((Object)((Object)this.parameters));
        }
        if (this.targetValue != null) {
            this.targetValueExpression = ExpressionLanguageUtils.compile((String)this.targetValue, (ExpressionLanguage)this.expressionManager);
        }
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        BindingContext additionalBindings = this.resolveAdditionalBindings(this.parameters, event);
        String scriptToEvaluate = (String)this.expression.resolveValue(event);
        if (scriptToEvaluate == null) {
            throw new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)"Expression evaluated to 'null'."));
        }
        CoreEvent result = CoreEvent.builder((CoreEvent)event).message(Message.builder().payload(this.expressionManager.evaluate(scriptToEvaluate, event, additionalBindings)).build()).build();
        return Operators.outputToTarget((CoreEvent)event, (CoreEvent)result, (String)this.target, (CompiledExpression)this.targetValueExpression, (ExpressionLanguage)this.expressionManager);
    }

    public void setParameters(DynamicEvaluateProcessorParameters parameters) {
        this.parameters = parameters;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    private BindingContext resolveAdditionalBindings(DynamicEvaluateProcessorParameters parameters, CoreEvent event) {
        return parameters != null ? parameters.toBindingContext(event) : BindingContextUtils.NULL_BINDING_CONTEXT;
    }

    public ReactiveProcessor.ProcessingType getProcessingType() {
        String processingType = System.getProperty("mule.dwScript.processingType");
        if (processingType != null) {
            try {
                return ReactiveProcessor.ProcessingType.valueOf((String)processingType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error("Invalid value for system property mule.dwScript.processingType: " + processingType);
                return ReactiveProcessor.ProcessingType.CPU_INTENSIVE;
            }
        }
        return ReactiveProcessor.ProcessingType.CPU_INTENSIVE;
    }
}

