/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.extractor;

import com.mulesoft.mule.runtime.gw.analytics.extractor.EnrichedServerNotificationEventIdExtractor;
import com.mulesoft.mule.runtime.gw.api.client.Client;
import java.util.Optional;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.security.Authentication;

public class EnrichedServerNotificationExtractor {
    private final EnrichedServerNotificationEventIdExtractor eventIdExtractor = new EnrichedServerNotificationEventIdExtractor();

    public String flow(EnrichedServerNotification notification) {
        if (notification == null) {
            throw new NullPointerException("Notification cannot be null");
        }
        return notification.getResourceIdentifier();
    }

    public String eventId(EnrichedServerNotification notification) {
        return this.eventIdExtractor.eventId(notification);
    }

    public Optional<Client> client(EnrichedServerNotification notification) {
        Authentication authentication;
        if (notification == null) {
            throw new NullPointerException("Notification cannot be null");
        }
        if (notification.getEvent().getAuthentication().isPresent() && (authentication = (Authentication)notification.getEvent().getAuthentication().get()).getProperties() != null && authentication.getProperties().containsKey("clientId")) {
            return Optional.of(new NoSecretClient((String)authentication.getProperties().get("clientId"), (String)authentication.getProperties().get("clientName")));
        }
        return Optional.empty();
    }

    static class NoSecretClient
    extends Client {
        private static final long serialVersionUID = 4049302420734670090L;
        private final String id;
        private final String name;

        NoSecretClient(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String id() {
            return this.id;
        }

        public String secret() {
            return null;
        }

        public String name() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NoSecretClient that = (NoSecretClient)((Object)o);
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

