/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.extractor;

import com.google.common.net.InetAddresses;
import com.mulesoft.mule.runtime.gw.analytics.extractor.ClientIpExtractor;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpRequestAttributes;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.MultiMap;

public class DefaultClientIpExtractor
implements ClientIpExtractor {
    private static final Pattern REMOTE_ADDRESS_PATTERN = Pattern.compile("([^/]*/+)?\\[?([^]]*)]?:(.*)");
    private static final String IP_SEPARATOR = ",";
    private static final String X_FORWARDED_FOR_LOWER = "X-Forwarded-For".toLowerCase();

    @Override
    public String extractClientIp(HttpRequestAttributes httpRequestAttributes) {
        return this.extractXForwardedIp(httpRequestAttributes.getHeaders()).orElse(this.extractRemoteAddressIp(httpRequestAttributes.getRemoteAddress()));
    }

    private String extractRemoteAddressIp(String remoteAddress) {
        if (remoteAddress != null) {
            Matcher ipMatcher = REMOTE_ADDRESS_PATTERN.matcher(remoteAddress);
            return ipMatcher.find() ? ipMatcher.group(2) : null;
        }
        return null;
    }

    private Optional<String> extractXForwardedIp(MultiMap<String, String> headers) {
        return Optional.ofNullable(headers.get((Object)X_FORWARDED_FOR_LOWER)).flatMap(header -> {
            String ip = header.contains(IP_SEPARATOR) ? StringUtils.substringBefore((String)header, (String)IP_SEPARATOR) : header;
            return InetAddresses.isInetAddress((String)ip) ? Optional.of(ip) : Optional.empty();
        });
    }
}

