/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import com.mulesoft.mule.runtime.gw.analytics.AnalyticsEventDispatcher;
import com.mulesoft.mule.runtime.gw.analytics.extractor.ClientIpExtractor;
import com.mulesoft.mule.runtime.gw.analytics.extractor.DefaultClientIpExtractor;
import com.mulesoft.mule.runtime.gw.analytics.extractor.EnrichedServerNotificationExtractor;
import com.mulesoft.mule.runtime.gw.analytics.extractor.NoopClientIpExtractor;
import com.mulesoft.mule.runtime.gw.analytics.feedbackloop.EdgeRequestDetector;
import com.mulesoft.mule.runtime.gw.analytics.feedbackloop.FeedbackLoopDDOSHeaderInjector;
import com.mulesoft.mule.runtime.gw.analytics.logger.AnalyticsEventLogger;
import com.mulesoft.mule.runtime.gw.analytics.model.AnalyticsEventBuilder;
import com.mulesoft.mule.runtime.gw.analytics.model.AnalyticsHttpEventBuilder;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpRequestAttributes;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpRequestAttributesFactory;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpResponseAttributesFactory;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;
import com.mulesoft.mule.runtime.gw.api.events.collector.service.EventsCollectorService;
import com.mulesoft.mule.runtime.gw.config.AnalyticsConfiguration;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.hdp.config.HighDensityProxyConfiguration;
import com.mulesoft.mule.runtime.gw.metrics.GatewayMetricsAdapter;
import com.mulesoft.mule.runtime.gw.model.Api;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsEventHandler.class);
    private final String muleAppName;
    private final ApiService apiService;
    private final AnalyticsEventDispatcher eventDispatcher;
    private final EnrichedServerNotificationExtractor extractor;
    private final Map<String, AnalyticsEventBuilder> eventBuilders = new ConcurrentHashMap<String, AnalyticsEventBuilder>();
    private final EventsCollectorService eventsCollectorService;
    private final AnalyticsEventLogger eventLogger;
    private final HttpRequestAttributesFactory httpRequestAttributesFactory = new HttpRequestAttributesFactory();
    private final HttpResponseAttributesFactory httpResponseAttributesFactory = new HttpResponseAttributesFactory();
    private final EdgeRequestDetector edgeRequestDetector = new EdgeRequestDetector();
    private final ClientIpExtractor clientIpExtractor;
    private Optional<GatewayMetricsAdapter> metricsCollector;
    private final FeedbackLoopDDOSHeaderInjector headerInjector = new FeedbackLoopDDOSHeaderInjector();
    private final HighDensityProxyConfiguration hdpConfiguration = new HighDensityProxyConfiguration();

    public AnalyticsEventHandler(String muleAppName, ApiService apiService, EnrichedServerNotificationExtractor extractor, AnalyticsEventDispatcher eventDispatcher, EventsCollectorService eventsCollectorService, Optional<GatewayMetricsAdapter> metricsCollector, AnalyticsEventLogger eventLogger) {
        this.muleAppName = muleAppName;
        this.apiService = apiService;
        this.extractor = extractor;
        this.eventDispatcher = eventDispatcher;
        this.eventsCollectorService = eventsCollectorService;
        this.clientIpExtractor = new AnalyticsConfiguration().includeClientIp() ? new DefaultClientIpExtractor() : new NoopClientIpExtractor();
        this.metricsCollector = metricsCollector;
        this.eventLogger = eventLogger;
    }

    public void startEvent(EnrichedServerNotification notification) {
        String flow;
        Optional<Api> api;
        if (!this.eventBuilders.containsKey(this.extractor.eventId(notification)) && (api = this.findApi(flow = this.extractor.flow(notification), notification)).isPresent() && api.get().getTrackingInfo().isTracked()) {
            LOGGER.debug("Processing Message Received Notification for '{}'", (Object)api.get().getKey());
            OptionalLong payloadLength = notification.getEvent().getMessage().getPayload().getByteLength();
            AnalyticsEventBuilder eventBuilder = new AnalyticsHttpEventBuilder(this.edgeRequestDetector, this.httpRequestAttributesFactory, this.httpResponseAttributesFactory, this.clientIpExtractor).withMuleAppName(this.muleAppName).withFlowName(flow).withId(this.extractor.eventId(notification)).withApi(api.get()).withReceivedTimestamp(notification.getTimestamp()).withRequest(payloadLength, notification.getEvent().getMessage().getAttributes());
            this.eventBuilders.put(this.key(notification, flow), eventBuilder);
        }
    }

    private Optional<Api> findApi(String flow, EnrichedServerNotification notification) {
        return this.apiService.find(this.muleAppName, flow, () -> {
            TypedValue attributes = notification.getEvent().getMessage().getAttributes();
            Optional<MultiMap> headers = this.httpRequestAttributesFactory.from((TypedValue<Object>)attributes).map(HttpRequestAttributes::getHeaders);
            String service = null;
            String serviceHeader = this.hdpConfiguration.getHdpServiceHeader();
            if (headers.isPresent() && headers.get().containsKey((Object)serviceHeader)) {
                service = (String)headers.get().get((Object)serviceHeader);
            }
            return service;
        });
    }

    public void finishEvent(EnrichedServerNotification notification) {
        AnalyticsEventBuilder eventBuilder = this.eventBuilders.remove(this.key(notification, this.extractor.flow(notification)));
        if (eventBuilder != null) {
            LOGGER.debug("Processing Message Response Notification for '{}'", (Object)eventBuilder.getApiDescription());
            OptionalLong payloadLength = notification.getEvent().getMessage().getPayload().getByteLength();
            TypedValue attributes = notification.getEvent().getMessage().getAttributes();
            eventBuilder.withResponse(payloadLength, (TypedValue<Object>)attributes, notification.getAction()).withRepliedTimestamp(notification.getTimestamp());
            this.extractor.client(notification).ifPresent(eventBuilder::withClient);
            this.eventsCollectorService.removeExtraViolationData(this.extractor.eventId(notification));
            this.eventsCollectorService.removePolicyViolation(this.extractor.eventId(notification)).ifPresent(policyViolation -> {
                eventBuilder.withPolicyViolation((PolicyViolation)policyViolation);
                if (eventBuilder.isEdgeRequest()) {
                    this.headerInjector.injectHeader(attributes.getValue(), (PolicyViolation)policyViolation);
                }
            });
            AnalyticsHttpEvent event = eventBuilder.build();
            this.eventLogger.logEvent(event);
            this.dispatchEvent(event, attributes.getValue());
        }
    }

    void dispatchEvent(AnalyticsHttpEvent event, Object attributes) {
        this.eventDispatcher.dispatch(event);
        this.metricsCollector.ifPresent(gatewayMetricsAdapter -> gatewayMetricsAdapter.requestReceived(event));
    }

    private String key(EnrichedServerNotification notification, String flow) {
        return this.extractor.eventId(notification) + "-" + flow;
    }
}

