/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.exception;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class ExceptionSerializationWrapper
extends Exception {
    private Exception delegate;
    private String message;
    private String localizedMessage;

    public ExceptionSerializationWrapper(Exception delegate) {
        this.delegate = delegate;
        this.message = delegate.getMessage();
        this.localizedMessage = delegate.getLocalizedMessage();
    }

    public Exception getDelegate() {
        return this.delegate;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getLocalizedMessage() {
        return this.localizedMessage;
    }

    @Override
    public synchronized Throwable getCause() {
        return this.delegate.getCause();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        try {
            this.checkSerialization(this.delegate);
        }
        catch (IOException iOException) {
            this.delegate = null;
        }
        stream.defaultWriteObject();
        stream.close();
    }

    private void checkSerialization(Object object) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectOutputStream oos = new ObjectOutputStream(new ByteArrayOutputStream());){
            oos.writeObject(object);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

