/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.transaction;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.engine.transaction.BaseBatchTransactionContextWrapper;
import com.mulesoft.mule.runtime.module.batch.internal.engine.transaction.BatchTransactionContextProvider;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;

public class ManagedBatchTransactionContextProvider
implements BatchTransactionContextProvider {
    private final LoadingCache<BatchJobInstanceAdapter, BatchTransactionContext> contexts;

    public ManagedBatchTransactionContextProvider(final BatchEngine batchEngine, final boolean transactional) {
        this.contexts = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<BatchJobInstanceAdapter, BatchTransactionContext>(){

            public BatchTransactionContext load(BatchJobInstanceAdapter jobInstance) throws Exception {
                BatchTransactionContext ctx = batchEngine.createTransactionContext(jobInstance);
                if (transactional) {
                    ctx.beginTransaction();
                }
                return new BatchTransactionContextWrapper(ctx, jobInstance);
            }
        });
    }

    @Override
    public BatchTransactionContext get(BatchJobInstanceAdapter jobInstance) {
        return (BatchTransactionContext)this.contexts.getUnchecked((Object)jobInstance);
    }

    public long size() {
        return this.contexts.size();
    }

    private void forget(BatchJobInstanceAdapter jobInstance) {
        this.contexts.invalidate((Object)jobInstance);
    }

    private class BatchTransactionContextWrapper
    extends BaseBatchTransactionContextWrapper {
        private final BatchJobInstanceAdapter jobInstance;

        private BatchTransactionContextWrapper(BatchTransactionContext delegate, BatchJobInstanceAdapter jobInstance) {
            super(delegate);
            this.jobInstance = jobInstance;
        }

        @Override
        public void rollback() throws ResourceManagerException {
            ManagedBatchTransactionContextProvider.this.forget(this.jobInstance);
            this.delegate.rollback();
        }

        @Override
        public void commit() throws ResourceManagerException {
            ManagedBatchTransactionContextProvider.this.forget(this.jobInstance);
            this.delegate.commit();
        }
    }
}

