/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.security;

import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.nio.IOUtil;
import java.nio.ByteBuffer;
import org.mule.encryption.Encrypter;
import org.mule.encryption.exception.MuleEncryptionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecrypterHandler
extends InboundHandler<ByteBuffer, ByteBuffer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecrypterHandler.class);
    private static final int HEADER_SIZE = 4;
    private int valueOffset;
    private int size;
    private boolean headerRead;
    private byte[] payload;
    private final Encrypter encrypter;

    public DecrypterHandler(Encrypter encrypter) {
        this.encrypter = encrypter;
    }

    public void handlerAdded() {
        this.initSrcBuffer();
    }

    public synchronized HandlerStatus onRead() {
        ((ByteBuffer)this.src).flip();
        try {
            while (((ByteBuffer)this.src).hasRemaining()) {
                if (!this.headerRead && ((ByteBuffer)this.src).remaining() < 4) {
                    HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                    return handlerStatus;
                }
                boolean readFullBlock = this.readNextChunk((ByteBuffer)this.src);
                if (this.size == 0) {
                    this.reset();
                    break;
                }
                if (!readFullBlock) continue;
                if (((ByteBuffer)this.dst).hasRemaining()) {
                    this.decryptBlock((ByteBuffer)this.dst);
                } else {
                    LOGGER.error("DecrypterHandler dst buffer was full, hence discarding a block of bytes");
                }
                this.reset();
            }
            HandlerStatus handlerStatus = HandlerStatus.CLEAN;
            return handlerStatus;
        }
        catch (MuleEncryptionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Couldn't decrypt data"), (Throwable)e);
        }
        finally {
            IOUtil.compactOrClear((ByteBuffer)((ByteBuffer)this.src));
        }
    }

    private boolean readNextChunk(ByteBuffer src) {
        if (!this.headerRead) {
            this.size = src.getInt();
            this.payload = new byte[this.size];
            this.headerRead = true;
        }
        if (this.size > 0) {
            boolean done;
            int bytesRead;
            int bytesNeeded;
            int bytesReadable = src.remaining();
            if (bytesReadable >= (bytesNeeded = this.size - this.valueOffset)) {
                bytesRead = bytesNeeded;
                done = true;
            } else {
                bytesRead = bytesReadable;
                done = false;
            }
            src.get(this.payload, this.valueOffset, bytesRead);
            this.valueOffset += bytesRead;
            return done;
        }
        return true;
    }

    private void reset() {
        this.headerRead = false;
        this.size = 0;
        this.valueOffset = 0;
        this.payload = null;
    }

    private void decryptBlock(ByteBuffer dst) throws MuleEncryptionException {
        if (this.payload != null && this.payload.length > 0) {
            byte[] decrypted = this.encrypter.decrypt(this.payload);
            dst.put(decrypted);
        }
    }
}

