/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.lock;

import com.hazelcast.core.IMap;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastTimeoutUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class HazelcastLock
implements Lock {
    private final IMap locksMap;
    private final String lockId;

    public HazelcastLock(IMap locksMap, String lockId) {
        this.locksMap = locksMap;
        this.lockId = lockId;
    }

    @Override
    public void lock() {
        this.locksMap.lock((Object)this.lockId);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock();
    }

    @Override
    public boolean tryLock() {
        return this.locksMap.tryLock((Object)this.lockId);
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return HazelcastTimeoutUtils.executeWithTimeoutIntervals(unit.toMillis(time), timeout -> this.locksMap.tryLock((Object)this.lockId, timeout.longValue(), TimeUnit.MILLISECONDS), result -> result);
    }

    @Override
    public void unlock() {
        this.locksMap.unlock((Object)this.lockId);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("newCondition() not supported in HazelcastLock");
    }
}

