/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.config.persistence;

import com.mulesoft.mule.runtime.module.cluster.internal.config.persistence.C3p0PooledDataSourceFactory;
import java.util.Properties;

public class JdbcMapStoreDataSourceConfiguration {
    private static final String DEFAULT_DATA_STORE_FACTORY_CLASS = C3p0PooledDataSourceFactory.class.getName();
    private String jdbcUrl;
    private String driverClassName;
    private String username;
    private String password;
    private String factoryClass;
    private Properties clusterProperties;

    private JdbcMapStoreDataSourceConfiguration(String factoryClass, String jdbcUrl, String driverClassName, String username, String password, Properties clusterProperties) {
        this.jdbcUrl = jdbcUrl;
        this.driverClassName = driverClassName;
        this.username = username;
        this.password = password;
        this.factoryClass = factoryClass;
        this.clusterProperties = clusterProperties;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFactoryClass() {
        if (this.factoryClass == null) {
            return DEFAULT_DATA_STORE_FACTORY_CLASS;
        }
        return this.factoryClass;
    }

    public Properties getClusterProperties() {
        return this.clusterProperties;
    }

    /* synthetic */ JdbcMapStoreDataSourceConfiguration(String string, String string2, String string3, String string4, String string5, Properties properties, JdbcMapStoreDataSourceConfiguration jdbcMapStoreDataSourceConfiguration) {
        this(string, string2, string3, string4, string5, properties);
    }

    public static class Builder {
        private String jdbcUrl;
        private String driverClassName;
        private String username;
        private String password;
        private Properties clusterProperties = new Properties();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder withJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public Builder withDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withClusterProperties(Properties clusterProperties) {
            this.clusterProperties = clusterProperties;
            return this;
        }

        public JdbcMapStoreDataSourceConfiguration build() {
            return new JdbcMapStoreDataSourceConfiguration(this.clusterProperties.getProperty("mule.cluster.jdbcstorefactoryclassname"), this.jdbcUrl, this.driverClassName, this.username, this.password, this.clusterProperties, null);
        }
    }
}

