/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.hazelcast.core.OperationTimeoutException;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterLocker;
import com.mulesoft.mule.runtime.module.cluster.internal.boot.notification.PrimaryClusterNodeNotifier;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastClusterLocker
extends Thread
implements ClusterLocker {
    private static final Logger logger = LoggerFactory.getLogger(HazelcastClusterLocker.class);
    public static final String PRIMARY_SERVER_LOCK_ID = "mule.polling.locked.object";
    private final HazelcastInstance hazelcastInstance;
    private final String lockName;
    private final PrimaryClusterNodeNotifier primaryClusterNodeNotifier;
    private final int heartbeatTimeoutSecs;
    private final Object pollingNodeLock = new Object();

    public HazelcastClusterLocker(String lockId, HazelcastInstance hazelcastInstance, PrimaryClusterNodeNotifier primaryClusterNodeNotifier, int heartbeatTimeoutSecs) {
        this.setName("cluster.poller");
        this.setDaemon(true);
        this.lockName = lockId;
        this.hazelcastInstance = hazelcastInstance;
        this.primaryClusterNodeNotifier = primaryClusterNodeNotifier;
        this.heartbeatTimeoutSecs = heartbeatTimeoutSecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNotification() throws InterruptedException {
        Object object = this.pollingNodeLock;
        synchronized (object) {
            ILock lock = this.getLock();
            do {
                logger.info("We are now the cluster polling node.");
                this.primaryClusterNodeNotifier.notifyPrimaryClusterNode();
                this.pollingNodeLock.wait();
            } while (lock.isLockedByCurrentThread());
            logger.info("We are no longer the polling node");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyIfPollingNode() {
        Object object = this.pollingNodeLock;
        synchronized (object) {
            this.pollingNodeLock.notify();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block12: {
            block9: while (true) {
                while (!this.isInterrupted()) {
                    try {
                        lock = this.getLock();
                        if (!lock.tryLock((long)(this.heartbeatTimeoutSecs / 10), TimeUnit.SECONDS)) continue block9;
                        this.waitForNotification();
                        continue block9;
                    }
                    catch (OperationTimeoutException ex) {
                        HazelcastClusterLocker.logger.warn("Timeout locking polling lock", (Throwable)ex);
                        continue block9;
                    }
                    catch (InterruptedException v0) {
                        HazelcastClusterLocker.currentThread().interrupt();
                        this.unlock();
                        return;
                    }
                    catch (Exception ex) {
                        block11: {
                            HazelcastClusterLocker.logger.warn("Exception locking polling lock, retying to get lock");
                            if (ex.getCause() == null || !(ex.getCause() instanceof InterruptedException)) break block11;
                            HazelcastClusterLocker.currentThread().interrupt();
                            this.unlock();
                            return;
                        }
                        if (HazelcastClusterLocker.logger.isDebugEnabled()) ** break;
                        continue block9;
                        HazelcastClusterLocker.logger.debug(ex.getMessage(), (Throwable)ex);
                    }
                }
                break block12;
                break;
            }
            finally {
                this.unlock();
            }
        }
    }

    private void unlock() {
        block3: {
            if (this.getLock() != null && this.getLock().isLockedByCurrentThread()) {
                try {
                    this.getLock().unlock();
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public ILock getLock() {
        return this.hazelcastInstance.getLock(this.lockName);
    }
}

