/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.core.HazelcastInstance;
import com.mulesoft.mule.runtime.module.cluster.internal.serialization.ClusterDistributedObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastClientInstanceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HazelcastClientInstanceBuilder.class);
    private ClientConfig clientConfig = new ClientConfig();
    private String clusterNodes;

    private HazelcastClientInstanceBuilder() {
    }

    public static HazelcastClientInstanceBuilder hazelcastClientInstanceBuilder() {
        return new HazelcastClientInstanceBuilder();
    }

    public HazelcastClientInstanceBuilder clusterNodes(String nodes) {
        this.clusterNodes = nodes;
        return this;
    }

    public HazelcastClientInstanceBuilder clusterId(String clusterId) {
        this.clientConfig.getGroupConfig().setName(clusterId);
        return this;
    }

    public HazelcastClientInstanceBuilder clusterPassword(String clusterPassword) {
        this.clientConfig.getGroupConfig().setPassword(clusterPassword);
        return this;
    }

    public HazelcastClientInstanceBuilder setClientName(String clientName) {
        this.clientConfig.setInstanceName(clientName);
        return this;
    }

    public HazelcastInstance build() {
        if (this.clusterNodes == null) {
            logger.warn("Cluster nodes or cluster host system property not provided");
            throw new IllegalArgumentException("Cluster nodes or cluster host system property not provided");
        }
        if (this.clusterNodes != null) {
            logger.info("Configuring cluster nodes " + this.clusterNodes);
            String[] clusterNodesList = this.clusterNodes.split(",");
            ClientNetworkConfig hzNetworkConfig = this.clientConfig.getNetworkConfig();
            String[] stringArray = clusterNodesList;
            int n = clusterNodesList.length;
            int n2 = 0;
            while (n2 < n) {
                String clusterNode = stringArray[n2];
                hzNetworkConfig.addAddress(new String[]{clusterNode}).setSmartRouting(true);
                ++n2;
            }
            this.clientConfig.setNetworkConfig(hzNetworkConfig);
        }
        this.clientConfig.getNetworkConfig().setConnectionAttemptLimit(0);
        ClusterDistributedObjectSerializer.configureInto(this.clientConfig);
        return HazelcastClient.newHazelcastClient((ClientConfig)this.clientConfig);
    }

    public HazelcastClientInstanceBuilder classLoader(ClassLoader classLoader) {
        this.clientConfig.setClassLoader(classLoader);
        return this;
    }
}

