/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.tracking;

import com.google.inject.Inject;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.external.handlers.tracking.TrackingRequest;
import com.mulesoft.agent.services.TrackingService;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Named(value="tracking.request.handler")
@Path(value="tracking")
@Singleton
public class TrackingExternalHandler
extends ConfigurableExternalHandler {
    @Inject
    private TrackingService trackingService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response trackApplication(TrackingRequest trackingRequest) {
        if (this.isEnabled()) {
            try {
                if (!StringUtils.isBlank((CharSequence)trackingRequest.getFlowName())) {
                    this.trackingService.track(trackingRequest.getApplicationName(), trackingRequest.getFlowName(), trackingRequest.getTrackingLevel(), trackingRequest.getReplayLevel(), trackingRequest.isPayloadExcluded(), trackingRequest.isPayloadInclusionEnforced(), trackingRequest.isUseEventModel());
                } else {
                    this.trackingService.track(trackingRequest.getApplicationName(), trackingRequest.getTrackingLevel(), trackingRequest.getReplayLevel(), trackingRequest.isPayloadExcluded(), trackingRequest.isPayloadInclusionEnforced(), trackingRequest.isUseEventModel());
                }
                return Response.accepted().build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response untrackApplication(TrackingRequest trackingRequest) {
        if (this.isEnabled()) {
            try {
                if (!StringUtils.isBlank((CharSequence)trackingRequest.getFlowName())) {
                    this.trackingService.untrack(trackingRequest.getApplicationName(), trackingRequest.getFlowName());
                } else {
                    this.trackingService.untrack(trackingRequest.getApplicationName());
                }
                return Response.accepted().build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @PUT
    @Path(value="{applicationName}/{flowName}/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response replay(@PathParam(value="applicationName") String applicationName, @PathParam(value="flowName") String flowName, @PathParam(value="transactionId") String transactionId) {
        if (this.isEnabled()) {
            try {
                this.trackingService.replay(applicationName, flowName, transactionId);
                return Response.accepted().build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }
}

