/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.extension.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.BaseComponentAstDecorator;
import org.mule.runtime.ast.api.util.MuleArtifactAstCopyUtils;
import org.mule.runtime.config.internal.dsl.model.extension.xml.MacroExpansionModuleModel;
import org.mule.runtime.extension.api.property.XmlExtensionModelProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroExpansionModulesModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroExpansionModulesModel.class);
    private static final String FILE_MACRO_EXPANSION_DELIMITER = StringUtils.repeat((char)'*', (int)80) + System.lineSeparator();
    private static final String FILE_MACRO_EXPANSION_SECTION_DELIMITER = StringUtils.repeat((char)'-', (int)80) + System.lineSeparator();
    private ArtifactAst applicationModel;
    private final List<ExtensionModel> sortedExtensions;

    public MacroExpansionModulesModel(ArtifactAst applicationModel, Set<ExtensionModel> extensions) {
        this.applicationModel = applicationModel;
        this.sortedExtensions = this.calculateExtensionByTopologicalOrder(extensions);
    }

    public ArtifactAst expand() {
        boolean hasMacroExpansionExtension = false;
        for (ExtensionModel extensionModel : this.sortedExtensions) {
            if (!extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent()) continue;
            hasMacroExpansionExtension = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("macro expanding '%s' connector, xmlns:%s=\"%s\"", extensionModel.getName(), extensionModel.getXmlDslModel().getPrefix(), extensionModel.getXmlDslModel().getNamespace()));
            }
            this.applicationModel = new MacroExpansionModuleModel(this.applicationModel, extensionModel).expand();
        }
        if (hasMacroExpansionExtension) {
            List componentsToAdd = this.applicationModel.recursiveStream().filter(comp -> TypedComponentIdentifier.ComponentType.FLOW.equals((Object)comp.getComponentType())).filter(comp -> !this.applicationModel.topLevelComponents().contains(comp)).collect(Collectors.toList());
            this.applicationModel = MuleArtifactAstCopyUtils.copyRecursively((ArtifactAst)this.applicationModel, comp -> {
                final List childrenToKeep = comp.directChildrenStream().filter(child -> !TypedComponentIdentifier.ComponentType.FLOW.equals((Object)child.getComponentType())).collect(Collectors.toList());
                return new BaseComponentAstDecorator((ComponentAst)comp){

                    public List<ComponentAst> directChildren() {
                        return childrenToKeep;
                    }

                    public Stream<ComponentAst> directChildrenStream() {
                        return childrenToKeep.stream();
                    }
                };
            }, () -> componentsToAdd, c -> false);
            if (LOGGER.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder(1024);
                buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_DELIMITER);
                AtomicReference lastFile = new AtomicReference();
                this.applicationModel.topLevelComponentsStream().forEach(comp -> {
                    String fileName = comp.getMetadata().getFileName().orElse("<unnamed>");
                    if (!fileName.equals(lastFile.get())) {
                        if (lastFile.get() != null) {
                            buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_SECTION_DELIMITER);
                        }
                        buf.append("Filename: ").append(fileName);
                        buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_SECTION_DELIMITER);
                        lastFile.set(fileName);
                    }
                    buf.append(comp.getMetadata().getSourceCode().orElse("")).append(System.lineSeparator());
                });
                buf.append(System.lineSeparator()).append(FILE_MACRO_EXPANSION_DELIMITER);
                LOGGER.debug(buf.toString());
            }
        }
        return this.applicationModel;
    }

    private List<ExtensionModel> calculateExtensionByTopologicalOrder(Set<ExtensionModel> extensions) {
        Set<String> extensionsUsedInApp;
        ArrayList<ExtensionModel> result = new ArrayList<ExtensionModel>();
        Map allExtensionsByNamespace = extensions.stream().filter(extensionModel -> extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent()).collect(Collectors.toMap(extModel -> extModel.getXmlDslModel().getNamespace(), Function.identity()));
        if (!allExtensionsByNamespace.isEmpty() && !(extensionsUsedInApp = this.applicationModel.recursiveStream().map(comp -> comp.getIdentifier().getNamespaceUri()).filter(ns -> allExtensionsByNamespace.keySet().contains(ns)).collect(Collectors.toSet())).isEmpty()) {
            DirectedMultigraph namespaceDAG = new DirectedMultigraph(DefaultEdge.class);
            extensionsUsedInApp.forEach(arg_0 -> this.lambda$calculateExtensionByTopologicalOrder$11((Graph)namespaceDAG, allExtensionsByNamespace, arg_0));
            TopologicalOrderIterator graphIterator = new TopologicalOrderIterator((Graph)namespaceDAG);
            while (graphIterator.hasNext()) {
                String namespace = (String)graphIterator.next();
                if (!allExtensionsByNamespace.containsKey(namespace)) continue;
                result.add((ExtensionModel)allExtensionsByNamespace.get(namespace));
            }
        }
        return result;
    }

    private void fillDependencyGraph(Graph<String, DefaultEdge> g, String sourceVertex, Map<String, ExtensionModel> allExtensionsByNamespace) {
        ExtensionModel extensionModel = allExtensionsByNamespace.get(sourceVertex);
        g.addVertex((Object)sourceVertex);
        for (String dependencyNamespace : this.getDependenciesOrFail(extensionModel)) {
            if (!allExtensionsByNamespace.containsKey(dependencyNamespace)) continue;
            g.addVertex((Object)dependencyNamespace);
            g.addEdge((Object)sourceVertex, (Object)dependencyNamespace);
            this.fillDependencyGraph(g, dependencyNamespace, allExtensionsByNamespace);
        }
    }

    private Set<String> getDependenciesOrFail(ExtensionModel extensionModel) {
        return ((XmlExtensionModelProperty)extensionModel.getModelProperty(XmlExtensionModelProperty.class).orElseThrow(() -> new IllegalArgumentException(String.format("The current extension [%s] (namespace [%s]) does not have the macro expansion model property, it should have never reach here.", extensionModel.getName(), extensionModel.getXmlDslModel().getNamespace())))).getNamespacesDependencies();
    }

    private /* synthetic */ void lambda$calculateExtensionByTopologicalOrder$11(Graph namespaceDAG, Map allExtensionsByNamespace, String namespace) {
        this.fillDependencyGraph((Graph<String, DefaultEdge>)namespaceDAG, namespace, allExtensionsByNamespace);
    }
}

