/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl.model.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.api.dsl.model.metadata.ComponentBasedIdHelper;
import org.mule.runtime.config.api.dsl.model.metadata.types.AttributesMetadataResolutionTypeInformation;
import org.mule.runtime.config.api.dsl.model.metadata.types.InputMetadataResolutionTypeInformation;
import org.mule.runtime.config.api.dsl.model.metadata.types.KeysMetadataResolutionTypeInformation;
import org.mule.runtime.config.api.dsl.model.metadata.types.MetadataResolutionTypeInformation;
import org.mule.runtime.config.api.dsl.model.metadata.types.OutputMetadataResolutionTypeInformation;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.locator.ComponentLocator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheId;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGenerator;
import org.mule.runtime.core.internal.util.cache.CacheIdBuilderAdapter;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;

public class ComponentAstBasedMetadataCacheIdGenerator
implements MetadataCacheIdGenerator<ComponentAst> {
    private final ComponentLocator<ComponentAst> locator;

    public ComponentAstBasedMetadataCacheIdGenerator(ComponentLocator<ComponentAst> locator) {
        this.locator = locator;
    }

    public Optional<MetadataCacheId> getIdForComponentOutputMetadata(ComponentAst component) {
        return component.getModel(HasOutputModel.class).flatMap(hom -> this.doResolveType(component, new OutputMetadataResolutionTypeInformation(component)));
    }

    public Optional<MetadataCacheId> getIdForComponentAttributesMetadata(ComponentAst component) {
        return component.getModel(HasOutputModel.class).flatMap(hom -> this.doResolveType(component, new AttributesMetadataResolutionTypeInformation(component)));
    }

    public Optional<MetadataCacheId> getIdForComponentInputMetadata(ComponentAst component, String parameterName) {
        Preconditions.checkArgument((boolean)component.getModel(ParameterizedModel.class).isPresent(), () -> "Cannot generate an Input Cache Key for component '" + component.toString() + "' with no parameters");
        Preconditions.checkArgument((boolean)((ParameterizedModel)component.getModel(ParameterizedModel.class).get()).getAllParameterModels().stream().anyMatch(parameterModel -> parameterModel.getName().equals(parameterName)), () -> "Cannot generate an Input Cache Key for component '" + component.toString() + "' since it does not have a parameter named " + parameterName);
        return this.doResolveType(component, new InputMetadataResolutionTypeInformation(component, parameterName));
    }

    public Optional<MetadataCacheId> getIdForComponentMetadata(ComponentAst elementModel) {
        return this.doResolve(elementModel);
    }

    public Optional<MetadataCacheId> getIdForMetadataKeys(ComponentAst elementModel) {
        return this.doResolveType(elementModel, new KeysMetadataResolutionTypeInformation(elementModel));
    }

    public Optional<MetadataCacheId> getIdForGlobalMetadata(ComponentAst elementModel) {
        ArrayList keyParts = new ArrayList();
        return Optional.of(elementModel.getModel(ConfigurationModel.class).map(cfgModel -> {
            keyParts.add(this.resolveDslTagId(elementModel));
            this.resolveGlobalElement(elementModel).ifPresent(keyParts::add);
            return new MetadataCacheId(keyParts, ComponentBasedIdHelper.sourceElementName(elementModel));
        }).orElseGet(() -> {
            Optional<MetadataCacheId> configId = this.resolveConfigId(elementModel);
            if (configId.isPresent()) {
                keyParts.add(configId.get());
                this.resolveCategoryId(elementModel).ifPresent(keyParts::add);
                return new MetadataCacheId(keyParts, ComponentBasedIdHelper.sourceElementName(elementModel));
            }
            return this.resolveDslTagId(elementModel);
        }));
    }

    private Optional<MetadataCacheId> resolveCategoryId(ComponentAst elementModel) {
        return elementModel.getModel(ComponentModel.class).flatMap(model -> model.getModelProperty(MetadataKeyIdModelProperty.class)).map(mp -> mp.getCategoryName().orElse(null)).map(this::createCategoryMetadataCacheId);
    }

    private Optional<MetadataCacheId> doResolveType(ComponentAst component, MetadataResolutionTypeInformation typeInformation) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        if (typeInformation.isDynamicType()) {
            this.resolveDslTagNamespace(component).ifPresent(keyParts::add);
            this.resolveConfigId(component).ifPresent(keyParts::add);
            typeInformation.getResolverCategory().ifPresent(resolverCategory -> keyParts.add(this.createCategoryMetadataCacheId((String)resolverCategory)));
            typeInformation.getResolverName().ifPresent(resolverName -> keyParts.add(this.createResolverMetadataCacheId((String)resolverName)));
            keyParts.add(typeInformation.getComponentTypeMetadataCacheId());
            component.getModel(ComponentModel.class).flatMap(cmpModel -> this.resolveMetadataKeyParts(component, (ComponentModel)cmpModel, typeInformation.shouldIncludeConfiguredMetadataKeys())).ifPresent(keyParts::add);
        } else {
            keyParts.add(this.resolveDslTagId(component));
            component.getModel(ConfigurationModel.class).flatMap(cfgModel -> this.resolveGlobalElement(component)).ifPresent(keyParts::add);
            keyParts.add(typeInformation.getComponentTypeMetadataCacheId());
        }
        return Optional.of(new MetadataCacheId(keyParts, typeInformation.getComponentTypeMetadataCacheId().getSourceElementName().map(sourceElementName -> String.format("(%s):(%s)", ComponentBasedIdHelper.sourceElementName(component), sourceElementName)).orElse(String.format("(%s):(%s)", ComponentBasedIdHelper.sourceElementName(component), "Unknown Type"))));
    }

    private Optional<MetadataCacheId> resolveDslTagNamespace(ComponentAst elementModel) {
        String namespace = elementModel.getIdentifier().getNamespace();
        return Optional.of(new MetadataCacheId(namespace.toLowerCase().hashCode(), namespace));
    }

    private Optional<MetadataCacheId> doResolve(ComponentAst elementModel) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        this.resolveConfigId(elementModel).ifPresent(keyParts::add);
        this.resolveCategoryId(elementModel).ifPresent(keyParts::add);
        keyParts.add(this.resolveDslTagId(elementModel));
        elementModel.getModel(ComponentModel.class).map(model -> this.resolveMetadataKeyParts(elementModel, (ComponentModel)model, true)).orElseGet(() -> this.resolveGlobalElement(elementModel)).ifPresent(keyParts::add);
        return Optional.of(new MetadataCacheId(keyParts, ComponentBasedIdHelper.sourceElementName(elementModel)));
    }

    private MetadataCacheId resolveDslTagId(ComponentAst elementModel) {
        ComponentIdentifier id = elementModel.getIdentifier();
        return new MetadataCacheId(id.hashCode(), id.toString());
    }

    private Optional<MetadataCacheId> resolveConfigId(ComponentAst elementModel) {
        return ComponentBasedIdHelper.resolveConfigName(elementModel).flatMap(this::getHashedGlobal);
    }

    private Optional<MetadataCacheId> resolveGlobalElement(ComponentAst elementModel) {
        List<String> parameterNamesRequiredForMetadata = this.parameterNamesRequiredForMetadataCacheId(elementModel);
        List parts = Stream.concat(elementModel.directChildrenStream().map(this::doResolve).filter(Optional::isPresent).map(Optional::get), elementModel.getModel(ParameterizedModel.class).map(pmz -> elementModel.getParameters().stream().filter(p -> p.getValue().getValue().isPresent()).filter(p -> parameterNamesRequiredForMetadata.contains(p.getModel().getName())).map(p -> this.resolveKeyFromSimpleValue(elementModel, (ComponentParameterAst)p))).orElse(Stream.empty())).collect(Collectors.toList());
        if (parts.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MetadataCacheId(parts, (String)ComponentBasedIdHelper.getModelNameAst(elementModel).orElse(null)));
    }

    private List<String> parameterNamesRequiredForMetadataCacheId(ComponentAst component) {
        return component.getModel(EnrichableModel.class).flatMap(model -> model.getModelProperty(RequiredForMetadataModelProperty.class).map(RequiredForMetadataModelProperty::getRequiredParameters)).orElse(Collections.emptyList());
    }

    private Optional<MetadataCacheId> resolveMetadataKeyParts(ComponentAst elementModel, ComponentModel componentModel, boolean resolveAllKeys) {
        boolean isPartialFetching = componentModel.getModelProperty(TypeResolversInformationModelProperty.class).map(mp -> mp.isPartialTypeKeyResolver()).orElse(false);
        if (isPartialFetching || resolveAllKeys) {
            List keyParts = elementModel.getParameters().stream().filter(p -> p.getValue().getValue().isPresent()).filter(p -> p.getModel().getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).sorted(Comparator.comparingInt(p -> ((MetadataKeyPartModelProperty)p.getModel().getModelProperty(MetadataKeyPartModelProperty.class).get()).getOrder())).map(p -> this.resolveKeyFromSimpleValue(elementModel, (ComponentParameterAst)p)).collect(Collectors.toList());
            return keyParts.isEmpty() ? Optional.empty() : Optional.of(new MetadataCacheId(keyParts, "metadataKeyValues"));
        }
        return Optional.empty();
    }

    private MetadataCacheId resolveKeyFromSimpleValue(ComponentAst elementModel, final ComponentParameterAst param) {
        MetadataCacheId notCheckingReferences = (MetadataCacheId)ComponentBasedIdHelper.computeIdFor(elementModel, param, () -> new MetadataCacheIdBuilderAdapter());
        return (MetadataCacheId)param.getValue().reduce(v -> notCheckingReferences, v -> {
            final Reference reference = new Reference();
            if (v instanceof ComponentAst) {
                param.getModel().getType().accept(new MetadataTypeVisitor(){

                    public void visitArrayType(ArrayType arrayType) {
                        ComponentAstBasedMetadataCacheIdGenerator.this.getHashedGlobal(param.getResolvedRawValue()).ifPresent(arg_0 -> ((Reference)reference).set(arg_0));
                    }

                    public void visitObject(ObjectType objectType) {
                        boolean canBeGlobal = objectType.getAnnotation(TypeDslAnnotation.class).map(TypeDslAnnotation::allowsTopLevelDefinition).orElse(false);
                        if (canBeGlobal) {
                            ComponentAstBasedMetadataCacheIdGenerator.this.getHashedGlobal(param.getResolvedRawValue()).ifPresent(arg_0 -> ((Reference)reference).set(arg_0));
                        }
                    }
                });
            } else {
                final ParameterModel paramModel = param.getModel();
                paramModel.getType().accept(new MetadataTypeVisitor(){

                    public void visitString(StringType stringType) {
                        if (!paramModel.getAllowedStereotypes().isEmpty()) {
                            ComponentAstBasedMetadataCacheIdGenerator.this.getHashedGlobal(v.toString()).ifPresent(arg_0 -> ((Reference)reference).set(arg_0));
                        }
                    }

                    public void visitArrayType(ArrayType arrayType) {
                        if (paramModel.getDslConfiguration().allowsReferences() && v instanceof String) {
                            ComponentAstBasedMetadataCacheIdGenerator.this.getHashedGlobal(v.toString()).ifPresent(arg_0 -> ((Reference)reference).set(arg_0));
                        }
                    }

                    public void visitObject(ObjectType objectType) {
                        if (paramModel.getDslConfiguration().allowsReferences()) {
                            ComponentAstBasedMetadataCacheIdGenerator.this.getHashedGlobal(v.toString()).ifPresent(arg_0 -> ((Reference)reference).set(arg_0));
                        }
                    }
                });
            }
            return reference.get() == null ? notCheckingReferences : (MetadataCacheId)reference.get();
        });
    }

    private MetadataCacheId createCategoryMetadataCacheId(String category) {
        return new MetadataCacheId(category.hashCode(), "category: " + category);
    }

    private MetadataCacheId createResolverMetadataCacheId(String resolverName) {
        return new MetadataCacheId(resolverName.hashCode(), "resolver: " + resolverName);
    }

    private Optional<MetadataCacheId> getHashedGlobal(String name) {
        if (!StringUtils.isBlank((String)name)) {
            return this.locator.get(Location.builder().globalName(name).build()).map(global -> this.doResolve((ComponentAst)global).orElse(null));
        }
        return Optional.empty();
    }

    private static class MetadataCacheIdBuilderAdapter
    implements CacheIdBuilderAdapter<MetadataCacheId> {
        private String name;
        private int value;
        private final List<MetadataCacheId> parts = new ArrayList<MetadataCacheId>();

        private MetadataCacheIdBuilderAdapter() {
        }

        public CacheIdBuilderAdapter<MetadataCacheId> withSourceElementName(String name) {
            this.name = name;
            return this;
        }

        public CacheIdBuilderAdapter<MetadataCacheId> withHashValue(int value) {
            this.value = value;
            return this;
        }

        public CacheIdBuilderAdapter<MetadataCacheId> containing(List<MetadataCacheId> parts) {
            this.parts.addAll(parts);
            return this;
        }

        public MetadataCacheId build() {
            if (this.parts.isEmpty()) {
                return new MetadataCacheId(this.value, this.name);
            }
            return new MetadataCacheId(this.parts, this.name);
        }
    }
}

