/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.exception.EnrichedErrorMapping;
import org.mule.runtime.core.internal.exception.ErrorMappingsAware;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;

public final class InternalExceptionUtils {
    private InternalExceptionUtils() {
    }

    public static CoreEvent createErrorEvent(CoreEvent currentEvent, Component obj, MessagingException me, ErrorTypeLocator locator) {
        Object cause = me.getCause() != null ? me.getCause() : me;
        List<Object> errorMappings = Collections.emptyList();
        if (obj instanceof ErrorMappingsAware) {
            errorMappings = ((ErrorMappingsAware)obj).getErrorMappings();
        }
        if (!errorMappings.isEmpty() || InternalExceptionUtils.isMessagingExceptionCause(me, (Throwable)cause)) {
            Error newError = InternalExceptionUtils.getErrorFromFailingProcessor(me.getExceptionInfo().getErrorType(), obj, (Throwable)cause, locator);
            CoreEvent newEvent = EventQuickCopy.quickCopy(newError, me.getEvent());
            me.setProcessedEvent(newEvent);
            return newEvent;
        }
        return currentEvent;
    }

    private static boolean isMessagingExceptionCause(MessagingException me, Throwable cause) {
        return !me.getEvent().getError().filter(error -> cause.equals(error.getCause())).filter(error -> me.causedExactlyBy(error.getCause().getClass())).isPresent();
    }

    public static Error getErrorFromFailingProcessor(ErrorType currentError, Component processor, Throwable cause, ErrorTypeLocator locator) {
        ErrorType errorType;
        ErrorType foundErrorType = locator.lookupErrorType(cause);
        ErrorType resultError = ExceptionUtils.isUnknownMuleError(foundErrorType) ? currentError : foundErrorType;
        ErrorType errorTypeLookedUp = ExceptionUtils.getComponentIdentifier(processor).map(ci -> locator.lookupComponentErrorType((ComponentIdentifier)ci, cause)).orElse(foundErrorType);
        ErrorType errorType2 = errorType = ExceptionUtils.isUnknownMuleError(errorTypeLookedUp) && resultError != null ? resultError : errorTypeLookedUp;
        if (processor instanceof ErrorMappingsAware) {
            List<EnrichedErrorMapping> errorMappings = ((ErrorMappingsAware)processor).getErrorMappings();
            if (errorMappings.isEmpty()) {
                return ErrorBuilder.builder(cause).errorType(errorType).build();
            }
            return ErrorBuilder.builder(cause).errorType(errorMappings.stream().filter(m -> m.match(resultError == null || ExceptionUtils.isUnknownMuleError(resultError) ? errorType : currentError)).findFirst().map(EnrichedErrorMapping::getTarget).orElse(errorType)).build();
        }
        return ErrorBuilder.builder(cause).errorType(errorType).build();
    }
}

