/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.DefaultMemoryManager;
import org.mule.runtime.core.internal.streaming.MemoryManager;
import org.mule.runtime.core.internal.streaming.bytes.ByteStreamingConstants;
import org.mule.runtime.core.internal.streaming.bytes.MaxStreamingMemoryExceededException;

public abstract class MemoryBoundByteBufferManager
implements ByteBufferManager {
    private final AtomicLong streamingMemory = new AtomicLong(0L);
    private final long maxStreamingMemory;

    public MemoryBoundByteBufferManager() {
        this(new DefaultMemoryManager());
    }

    public MemoryBoundByteBufferManager(MemoryManager memoryManager) {
        this.maxStreamingMemory = this.calculateMaxStreamingMemory(memoryManager);
    }

    protected final ByteBuffer allocateIfFits(int capacity) {
        if (this.streamingMemory.addAndGet(capacity) <= this.maxStreamingMemory) {
            return ByteBuffer.allocate(capacity);
        }
        this.streamingMemory.addAndGet(-capacity);
        throw new MaxStreamingMemoryExceededException(I18nMessageFactory.createStaticMessage((String)String.format("Max streaming memory limit of %d bytes was exceeded", this.maxStreamingMemory)));
    }

    @Override
    @Deprecated
    public ByteBuffer allocate(int capacity) {
        return this.allocateIfFits(capacity);
    }

    @Override
    @Deprecated
    public void deallocate(ByteBuffer byteBuffer) {
        this.doDeallocate(byteBuffer);
    }

    protected void doDeallocate(ByteBuffer byteBuffer) {
        this.streamingMemory.addAndGet(-byteBuffer.capacity());
    }

    private long calculateMaxStreamingMemory(MemoryManager memoryManager) {
        String maxMemoryProperty = System.getProperty("mule.max.streaming.memory");
        if (maxMemoryProperty == null) {
            return Math.round((double)memoryManager.getMaxMemory() * ByteStreamingConstants.MAX_STREAMING_MEMORY_PERCENTAGE);
        }
        try {
            return Long.valueOf(maxMemoryProperty);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid value for system property '%s'. A memory size (in bytes) was expected, got '%s' instead", "mule.max.streaming.memory", maxMemoryProperty));
        }
    }
}

