/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.streaming.exception.StreamingBufferSizeExceededException;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.ManagedByteBufferWrapper;
import org.mule.runtime.core.internal.streaming.bytes.AbstractInputStreamBuffer;

public class InMemoryStreamBuffer
extends AbstractInputStreamBuffer {
    private static final int STREAM_FINISHED_PROBE = 10;
    private ManagedByteBufferWrapper managedBuffer;
    private ByteBuffer actingBuffer;
    private final int bufferSizeIncrement;
    private final int maxBufferSize;
    private long bufferTip = 0L;

    public InMemoryStreamBuffer(InputStream stream, InMemoryCursorStreamConfig config, ByteBufferManager bufferManager) {
        super(stream, bufferManager);
        this.managedBuffer = bufferManager.allocateManaged(config.getInitialBufferSize().toBytes());
        this.actingBuffer = this.managedBuffer.getDelegate();
        this.bufferSizeIncrement = config.getBufferSizeIncrement() != null ? config.getBufferSizeIncrement().toBytes() : 0;
        this.maxBufferSize = config.getMaxBufferSize().toBytes();
    }

    @Override
    protected ByteBuffer doGet(long position, int length) {
        return this.doGet(position, length, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteBuffer doGet(long position, int length, boolean consumeStreamIfNecessary) {
        this.readLock.lock();
        try {
            ByteBuffer presentRead = this.getFromCurrentData(position, length);
            if (presentRead != null) {
                ByteBuffer byteBuffer = presentRead;
                return byteBuffer;
            }
            if (consumeStreamIfNecessary) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    ByteBuffer refetch = this.getFromCurrentData(position, length);
                    if (refetch != null) {
                        ByteBuffer byteBuffer = refetch;
                        return byteBuffer;
                    }
                    long requiredUpperBound = position + (long)length;
                    while (!this.streamFullyConsumed && this.bufferTip < requiredUpperBound) {
                        int read = this.consumeForwardData();
                        if (read > 0) {
                            refetch = this.getFromCurrentData(position, Math.min(length, read));
                            if (refetch == null) continue;
                            ByteBuffer byteBuffer = refetch;
                            return byteBuffer;
                        }
                        this.actingBuffer.limit(this.actingBuffer.position());
                    }
                    ByteBuffer byteBuffer = this.doGet(position, length, false);
                    return byteBuffer;
                }
                catch (IOException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not read stream"), (Throwable)e);
                }
                finally {
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
            }
            ByteBuffer byteBuffer = this.getFromCurrentData(position, length);
            return byteBuffer;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private ByteBuffer getFromCurrentData(long position, int length) {
        if (this.streamFullyConsumed && position > this.bufferTip) {
            return null;
        }
        if (position < this.bufferTip) {
            length = Math.min(length, Math.toIntExact(this.bufferTip - position));
            return this.copy(position, length);
        }
        return null;
    }

    @Override
    public void doClose() {
        this.managedBuffer.release();
        this.managedBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int consumeForwardData() throws IOException {
        int read;
        ManagedByteBufferWrapper b = this.managedBuffer;
        ManagedByteBufferWrapper managedReadBuffer = b.getDelegate().hasRemaining() ? b : this.bufferManager.allocateManaged(this.bufferSizeIncrement > 0 ? this.bufferSizeIncrement : 10);
        ByteBuffer readBuffer = managedReadBuffer.getDelegate();
        boolean auxBuffer = managedReadBuffer != b;
        try {
            read = this.consumeStream(readBuffer);
            if (read > 0) {
                if (auxBuffer) {
                    this.expandBuffer();
                    readBuffer.flip();
                    this.actingBuffer.put(readBuffer);
                }
                this.bufferTip += (long)read;
            }
        }
        finally {
            if (auxBuffer) {
                managedReadBuffer.release();
            }
        }
        return read;
    }

    private ManagedByteBufferWrapper expandBuffer() {
        ManagedByteBufferWrapper oldManagedBuffer = this.managedBuffer;
        ByteBuffer oldBuffer = oldManagedBuffer.getDelegate();
        int newSize = oldBuffer.capacity() + this.bufferSizeIncrement;
        if (!this.canBeExpandedTo(newSize)) {
            throw new StreamingBufferSizeExceededException(this.maxBufferSize);
        }
        ManagedByteBufferWrapper newManagedBuffer = this.bufferManager.allocateManaged(newSize);
        ByteBuffer newBuffer = newManagedBuffer.getDelegate();
        oldBuffer.position(0);
        newBuffer.put(oldBuffer);
        this.managedBuffer = newManagedBuffer;
        this.actingBuffer = newBuffer;
        oldManagedBuffer.release();
        return newManagedBuffer;
    }

    @Override
    protected ByteBuffer copy(long position, int length) {
        return this.canDoSoftCopy() ? this.softCopy(position, length) : this.hardCopy(position, length);
    }

    private ByteBuffer softCopy(long position, int length) {
        int offset = Math.toIntExact(position);
        return ByteBuffer.wrap(this.actingBuffer.array(), offset, Math.min(length, this.actingBuffer.limit() - offset)).slice();
    }

    protected ByteBuffer hardCopy(long position, int length) {
        int offset = Math.toIntExact(position);
        length = Math.min(length, this.actingBuffer.limit() - offset);
        byte[] b = new byte[length];
        System.arraycopy(this.actingBuffer.array(), offset, b, 0, length);
        return ByteBuffer.wrap(b);
    }

    private boolean canDoSoftCopy() {
        return this.streamFullyConsumed || this.actingBuffer.capacity() >= this.maxBufferSize || this.bufferSizeIncrement == 0;
    }

    private boolean canBeExpandedTo(int newSize) {
        if (this.bufferSizeIncrement <= 0) {
            return false;
        }
        if (this.maxBufferSize == 0) {
            return true;
        }
        return newSize <= this.maxBufferSize;
    }
}

