/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.security.tls;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.mule.runtime.core.internal.util.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedSSLServerSocketFactory
extends SSLServerSocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(RestrictedSSLServerSocketFactory.class);
    private final SSLServerSocketFactory sslServerSocketFactory;
    private final String[] enabledCipherSuites;
    private final String[] enabledProtocols;
    private final String[] defaultCipherSuites;

    public RestrictedSSLServerSocketFactory(SSLContext sslContext, String[] cipherSuites, String[] protocols) {
        this.sslServerSocketFactory = sslContext.getServerSocketFactory();
        if (cipherSuites == null) {
            cipherSuites = this.sslServerSocketFactory.getDefaultCipherSuites();
        }
        this.enabledCipherSuites = ArrayUtils.intersection(cipherSuites, this.sslServerSocketFactory.getSupportedCipherSuites());
        this.defaultCipherSuites = ArrayUtils.intersection(cipherSuites, this.sslServerSocketFactory.getDefaultCipherSuites());
        if (protocols == null) {
            protocols = sslContext.getDefaultSSLParameters().getProtocols();
        }
        this.enabledProtocols = ArrayUtils.intersection(protocols, sslContext.getSupportedSSLParameters().getProtocols());
        if (this.enabledProtocols.length != protocols.length) {
            logger.warn("Current context supports less SSL protocols than configured. Only the following are enabled: [{}]", (Object)Joiner.on((String)", ").join((Object[])this.enabledProtocols));
        }
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return this.restrictCipherSuites((SSLServerSocket)this.sslServerSocketFactory.createServerSocket());
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.restrictCipherSuites((SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.restrictCipherSuites((SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, backlog));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return this.restrictCipherSuites((SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, backlog, ifAddress));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.defaultCipherSuites;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.enabledCipherSuites;
    }

    private SSLServerSocket restrictCipherSuites(SSLServerSocket sslServerSocket) {
        sslServerSocket.setEnabledCipherSuites(this.enabledCipherSuites);
        sslServerSocket.setEnabledProtocols(this.enabledProtocols);
        return sslServerSocket;
    }
}

