/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Objects;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;

public interface ForkJoinStrategy {
    public Publisher<CoreEvent> forkJoin(CoreEvent var1, Publisher<RoutingPair> var2);

    public static final class RoutingPair {
        private final MessageProcessorChain route;
        private final CoreEvent event;

        public static RoutingPair of(CoreEvent event, MessageProcessorChain route) {
            return new RoutingPair(event, route);
        }

        private RoutingPair(CoreEvent event, MessageProcessorChain route) {
            this.event = Objects.requireNonNull(event);
            this.route = Objects.requireNonNull(route);
        }

        public MessageProcessorChain getRoute() {
            return this.route;
        }

        public CoreEvent getEvent() {
            return this.event;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoutingPair pair = (RoutingPair)o;
            if (!this.route.equals(pair.route)) {
                return false;
            }
            return this.event.equals(pair.event);
        }

        public int hashCode() {
            int result = this.route.hashCode();
            result = 31 * result + this.event.hashCode();
            return result;
        }
    }
}

