/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.event.EventInternalContextResolver;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.routing.ProcessorRoute;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

class FirstSuccessfulRouter {
    private final Logger LOGGER = LoggerFactory.getLogger(FirstSuccessfulRouter.class);
    private static final String FIRST_SUCCESSFUL_START_EVENT = "_firstSuccessfulStartEvent";
    private final Component owner;
    private final Flux<CoreEvent> upstreamFlux;
    private final List<Flux<CoreEvent>> innerFluxes = new ArrayList<Flux<CoreEvent>>();
    private final List<FluxSinkRecorder<CoreEvent>> innerRecorders;
    private final Flux<CoreEvent> downstreamFlux;
    private final FluxSinkRecorder<Either<Throwable, CoreEvent>> downstreamRecorder = new FluxSinkRecorder();
    private final EventInternalContextResolver<Stack<CoreEvent>> nextExecutionContextResolver = new EventInternalContextResolver<Stack>("_firstSuccessfulStartEvent", Stack::new);
    private final AtomicReference<Context> downstreamContextReference = new AtomicReference<Context>(Context.empty());
    private final AtomicInteger inflightEvents = new AtomicInteger(0);
    private final AtomicBoolean completeDeferred = new AtomicBoolean(false);

    private boolean isOriginalError(Error newError, Optional<Error> originalError) {
        return originalError.map(error -> error.equals(newError)).orElse(false);
    }

    public FirstSuccessfulRouter(Component owner, Publisher<CoreEvent> publisher, List<ProcessorRoute> routes) {
        this.owner = owner;
        this.innerRecorders = routes.stream().map(x -> new FluxSinkRecorder()).collect(Collectors.toList());
        this.upstreamFlux = Flux.from(publisher).doOnNext(event -> {
            this.inflightEvents.getAndIncrement();
            this.innerRecorders.get(0).next(this.startEvent((CoreEvent)event));
        }).doOnComplete(() -> {
            if (this.inflightEvents.get() == 0) {
                this.completeRouter();
            } else {
                this.completeDeferred.set(true);
            }
        });
        for (int i = 0; i < routes.size(); ++i) {
            FluxSinkRecorder<CoreEvent> nextRecorder = i < routes.size() - 1 ? this.innerRecorders.get(i + 1) : null;
            this.innerFluxes.add(this.createMidFlux(routes.get(i), this.innerRecorders.get(i), Optional.ofNullable(nextRecorder)));
        }
        this.downstreamFlux = Flux.create(sink -> {
            this.downstreamRecorder.accept((FluxSink<Either<Throwable, CoreEvent>>)sink);
            this.subscribeUpstreamChains(this.downstreamContextReference.get());
        }).doOnNext(event -> this.inflightEvents.decrementAndGet()).map(this.getScopeResultMapper());
    }

    private Function<Either<Throwable, CoreEvent>, CoreEvent> getScopeResultMapper() {
        return either -> {
            if (either.isLeft()) {
                throw Exceptions.propagate((Throwable)((Throwable)either.getLeft()));
            }
            return (CoreEvent)either.getRight();
        };
    }

    private void completeRouter() {
        for (FluxSinkRecorder<CoreEvent> innerRecorder : this.innerRecorders) {
            innerRecorder.complete();
        }
        this.downstreamRecorder.complete();
    }

    private void completeRouterIfNecessary() {
        if (this.completeDeferred.get() && this.inflightEvents.get() == 0) {
            this.completeRouter();
        }
    }

    Publisher<CoreEvent> getDownstreamPublisher() {
        return this.downstreamFlux.compose(downstreamPublisher -> Mono.subscriberContext().flatMapMany(downstreamContext -> downstreamPublisher.doOnSubscribe(s -> this.downstreamContextReference.set((Context)downstreamContext))));
    }

    private void subscribeUpstreamChains(Context downstreamContext) {
        for (Flux<CoreEvent> innerFlux : this.innerFluxes) {
            innerFlux.subscriberContext(downstreamContext).subscribe();
        }
        this.upstreamFlux.subscriberContext(downstreamContext).subscribe();
    }

    private CoreEvent startEvent(CoreEvent event) {
        Stack<CoreEvent> nextEventContainer = this.nextExecutionContextResolver.getCurrentContextFromEvent(event);
        nextEventContainer.push(event);
        return this.nextExecutionContextResolver.eventWithContext(event, nextEventContainer);
    }

    private void executeNext(Optional<FluxSinkRecorder<CoreEvent>> next, CoreEvent event, Throwable error) {
        Stack<CoreEvent> nextEventContainer = this.nextExecutionContextResolver.getCurrentContextFromEvent(event);
        CoreEvent nextEvent = nextEventContainer.pop();
        if (next.isPresent()) {
            next.get().next(this.startEvent(nextEvent));
        } else {
            this.downstreamRecorder.next((Either<Throwable, CoreEvent>)Either.left((Object)error, CoreEvent.class));
        }
    }

    private Flux<CoreEvent> createMidFlux(ProcessorRoute route, FluxSinkRecorder<CoreEvent> innerRecorder, Optional<FluxSinkRecorder<CoreEvent>> next) {
        return innerRecorder.flux().transform(innerPublisher -> MessageProcessors.applyWithChildContext((Publisher<CoreEvent>)innerPublisher, route.getProcessor(), Optional.of(this.owner.getLocation()))).doOnNext(successfulEvent -> {
            if (successfulEvent.getError().isPresent()) {
                CoreEvent originalEvent = this.nextExecutionContextResolver.getCurrentContextFromEvent((CoreEvent)successfulEvent).peek();
                if (!this.isOriginalError((Error)successfulEvent.getError().get(), originalEvent.getError())) {
                    this.executeNext(next, (CoreEvent)successfulEvent, ((Error)successfulEvent.getError().get()).getCause());
                    return;
                }
            }
            this.inflightEvents.decrementAndGet();
            Stack<CoreEvent> nextEventContainer = this.nextExecutionContextResolver.getCurrentContextFromEvent((CoreEvent)successfulEvent);
            nextEventContainer.pop();
            this.downstreamRecorder.next((Either<Throwable, CoreEvent>)Either.right(Throwable.class, (Object)this.nextExecutionContextResolver.eventWithContext((CoreEvent)successfulEvent, nextEventContainer)));
            this.completeRouterIfNecessary();
        }).onErrorContinue((error, object) -> {
            if (object instanceof CoreEvent) {
                this.executeNext(next, (CoreEvent)object, (Throwable)error);
            } else if (error instanceof MessagingException) {
                this.executeNext(next, ((MessagingException)((Object)((Object)error))).getEvent(), (Throwable)error);
            }
        });
    }
}

