/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public class DefaultEventContextService
implements EventContextService {
    private final Set<DefaultEventContext> currentContexts = ConcurrentHashMap.newKeySet(512);

    @Override
    public List<EventContextService.FlowStackEntry> getCurrentlyActiveFlowStacks() {
        ArrayList<EventContextService.FlowStackEntry> flowStacks = new ArrayList<EventContextService.FlowStackEntry>();
        for (DefaultEventContext context : this.currentContexts) {
            flowStacks.add(new DefaultFlowStackEntry(context));
            context.forEachChild(childContext -> flowStacks.add(new DefaultFlowStackEntry((BaseEventContext)childContext)));
        }
        return flowStacks;
    }

    public void addContext(DefaultEventContext context) {
        this.currentContexts.add(context);
    }

    public void removeContext(DefaultEventContext context) {
        this.currentContexts.remove(context);
    }

    private static final class DefaultFlowStackEntry
    implements EventContextService.FlowStackEntry {
        private final String serverId;
        private final String eventId;
        private final String originatingLocation;
        private final FlowCallStack flowCallStack;

        public DefaultFlowStackEntry(BaseEventContext context) {
            this.serverId = context.getServerId();
            this.eventId = context.getId();
            this.originatingLocation = context.getOriginatingLocation().getLocation();
            this.flowCallStack = context.getFlowCallStack().clone();
        }

        @Override
        public String getServerId() {
            return this.serverId;
        }

        @Override
        public String getEventId() {
            return this.eventId;
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.flowCallStack;
        }

        public String toString() {
            return "eventId: " + this.eventId + " @ " + this.originatingLocation + ";" + System.lineSeparator() + this.getFlowCallStack().toString();
        }
    }
}

