/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.internal.AbstractMuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.mule.tooling.client.internal.LoadedExtensionInformation;

public class DefaultMuleRuntimeExtensionModelProvider
extends AbstractMuleRuntimeExtensionModelProvider {
    public DefaultMuleRuntimeExtensionModelProvider(MavenClient mavenClient, InternalExtensionModelService extensionModelService) {
        super(mavenClient, extensionModelService);
    }

    @Override
    public Optional<ExtensionModel> getExtensionModel(ArtifactDescriptor pluginDescriptor) {
        return this.extensionModelService.loadExtensionData(this.toBundleDescriptor(pluginDescriptor)).map(loadedExtensionInformation -> loadedExtensionInformation.getExtensionModel());
    }

    @Override
    public Optional<String> getMinMuleVersion(ArtifactDescriptor pluginDescriptor) {
        return this.extensionModelService.loadExtensionData(this.toBundleDescriptor(pluginDescriptor)).map(loadedExtensionInformation -> loadedExtensionInformation.getMinMuleVersion());
    }

    @Override
    public Optional<LoadedExtensionInformation> getExtensionModel(File pluginFile) {
        return this.extensionModelService.loadExtensionData(pluginFile);
    }

    @Override
    public Optional<ExtensionModel> getExtensionModel(BundleDependency bundleDependency) {
        return this.extensionModelService.loadExtensionData(bundleDependency.getDescriptor()).map(loadedExtensionInformation -> loadedExtensionInformation.getExtensionModel());
    }

    @Override
    public Set<ExtensionModel> loadExtensionModels(List<ArtifactClassLoader> artifactPluginClassLoaders) {
        HashSet extensionModels = Sets.newHashSet();
        for (ArtifactClassLoader artifactClassLoader : artifactPluginClassLoaders) {
            Optional<LoadedExtensionInformation> loadedExtensionInformation = this.extensionModelService.loadExtensionData(artifactClassLoader, artifactPluginClassLoaders);
            loadedExtensionInformation.ifPresent(modelInformation -> extensionModels.add(modelInformation.getExtensionModel()));
        }
        return extensionModels;
    }

    @Override
    public Optional<String> getMinMuleVersion(File pluginFile) {
        return this.extensionModelService.loadExtensionData(pluginFile).map(loadedExtensionInformation -> loadedExtensionInformation.getMinMuleVersion());
    }

    @Override
    public Optional<String> getExtensionSchema(File pluginFile) {
        return this.extensionModelService.loadExtensionData(pluginFile).map(loadedExtensionInformation -> (String)loadedExtensionInformation.getSchema().get());
    }

    @Override
    public Optional<String> getExtensionSchema(ArtifactDescriptor pluginDescriptor) {
        return this.extensionModelService.loadExtensionData(this.toBundleDescriptor(pluginDescriptor)).map(loadedExtensionInformation -> (String)loadedExtensionInformation.getSchema().get());
    }

    @Override
    public List<ExtensionModel> getRuntimeExtensionModels() {
        return this.extensionModelService.loadRuntimeExtensionModels();
    }
}

