/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component.config;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;

@NoExtend
public class DefaultComponentLocation
implements ComponentLocation,
Serializable {
    private static final long serialVersionUID = 4958158607813720623L;
    private final String name;
    private final LinkedList<DefaultLocationPart> parts;
    private volatile String location;
    private transient String rootContainerName;
    private transient TypedComponentIdentifier componentIdentifier;

    public static ComponentLocation from(String component) {
        return DefaultComponentLocation.fromSingleComponent(component);
    }

    @Deprecated
    public static DefaultComponentLocation fromSingleComponent(String component) {
        DefaultLocationPart part = new DefaultLocationPart(component, Optional.of(TypedComponentIdentifier.builder().type(TypedComponentIdentifier.ComponentType.UNKNOWN).identifier(ComponentIdentifier.buildFromStringRepresentation((String)component)).build()), Optional.empty(), OptionalInt.empty(), OptionalInt.empty());
        return new DefaultComponentLocation(Optional.of(component), Arrays.asList(part));
    }

    public DefaultComponentLocation(Optional<String> name, List<DefaultLocationPart> parts) {
        this.name = name.orElse(null);
        this.parts = new LinkedList<DefaultLocationPart>(parts);
        this.componentIdentifier = this.calculateComponentIdentifier(parts);
        this.rootContainerName = this.calculateRootContainerName();
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public List<LocationPart> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    public TypedComponentIdentifier getComponentIdentifier() {
        if (this.componentIdentifier == null) {
            throw new NoSuchElementException("No 'componentIdentifier' set for location '" + this.getLocation() + "'");
        }
        return this.componentIdentifier;
    }

    public Optional<String> getFileName() {
        return this.parts.getLast().getFileName();
    }

    public Optional<Integer> getLineInFile() {
        return this.parts.getLast().getLineInFile();
    }

    public Optional<Integer> getStartColumn() {
        return this.parts.getLast().getStartColumn();
    }

    public OptionalInt getLine() {
        return this.parts.getLast().getLine();
    }

    public OptionalInt getColumn() {
        return this.parts.getLast().getColumn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocation() {
        if (this.location == null) {
            DefaultComponentLocation defaultComponentLocation = this;
            synchronized (defaultComponentLocation) {
                if (this.location == null) {
                    StringBuilder locationBuilder = new StringBuilder();
                    for (DefaultLocationPart part : this.parts) {
                        locationBuilder.append("/").append(part.getPartPath());
                    }
                    this.location = locationBuilder.replace(0, 1, "").toString();
                }
            }
        }
        return this.location;
    }

    public String getRootContainerName() {
        return this.rootContainerName;
    }

    private String calculateRootContainerName() {
        return this.getParts().isEmpty() ? null : this.getParts().get(0).getPartPath();
    }

    public DefaultComponentLocation appendLocationPart(String partPath, Optional<TypedComponentIdentifier> partIdentifier, Optional<String> fileName, OptionalInt lineInFile, OptionalInt startColumn) {
        return new DefaultComponentLocation(Optional.ofNullable(this.name), (List<DefaultLocationPart>)ImmutableList.builder().addAll(this.parts).add((Object)new DefaultLocationPart(partPath, partIdentifier, fileName, lineInFile, startColumn)).build());
    }

    @Deprecated
    public DefaultComponentLocation appendLocationPart(String partPath, Optional<TypedComponentIdentifier> partIdentifier, Optional<String> fileName, Optional<Integer> lineInFile, Optional<Integer> startColumn) {
        return new DefaultComponentLocation(Optional.ofNullable(this.name), (List<DefaultLocationPart>)ImmutableList.builder().addAll(this.parts).add((Object)new DefaultLocationPart(partPath, partIdentifier, fileName, lineInFile, startColumn)).build());
    }

    public DefaultComponentLocation appendProcessorsPart() {
        return new DefaultComponentLocation(Optional.ofNullable(this.name), (List<DefaultLocationPart>)ImmutableList.builder().addAll(this.parts).add((Object)new DefaultLocationPart("processors", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty())).build());
    }

    public DefaultComponentLocation appendRoutePart() {
        return new DefaultComponentLocation(Optional.ofNullable(this.name), (List<DefaultLocationPart>)ImmutableList.builder().addAll(this.parts).add((Object)new DefaultLocationPart("route", Optional.empty(), Optional.empty(), OptionalInt.empty(), OptionalInt.empty())).build());
    }

    public DefaultComponentLocation appendConnectionPart(Optional<TypedComponentIdentifier> partIdentifier, Optional<String> fileName, OptionalInt lineInFile, OptionalInt startColumn) {
        return new DefaultComponentLocation(Optional.ofNullable(this.name), (List<DefaultLocationPart>)ImmutableList.builder().addAll(this.parts).add((Object)new DefaultLocationPart("connection", partIdentifier, fileName, lineInFile, startColumn)).build());
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.componentIdentifier = this.calculateComponentIdentifier(this.parts);
        this.rootContainerName = this.calculateRootContainerName();
    }

    protected TypedComponentIdentifier calculateComponentIdentifier(List<DefaultLocationPart> parts) {
        return parts.isEmpty() ? null : (TypedComponentIdentifier)parts.get(parts.size() - 1).getPartIdentifier().orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultComponentLocation that = (DefaultComponentLocation)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (!this.getParts().equals(that.getParts())) {
            return false;
        }
        return this.getLocation() != null ? this.getLocation().equals(that.getLocation()) : that.getLocation() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + this.getParts().hashCode();
        result = 31 * result + (this.getLocation() != null ? this.getLocation().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultComponentLocation{name='" + this.name + '\'' + ", parts=" + this.parts + ", location='" + this.getLocation() + '\'' + '}';
    }

    @NoInstantiate
    @NoExtend
    public static class DefaultLocationPart
    implements LocationPart,
    Serializable {
        private static final long serialVersionUID = 5757545892752260058L;
        private final String partPath;
        private final TypedComponentIdentifier partIdentifier;
        private String fileName;
        private transient int lineInFile = -1;
        private transient int startColumn = -1;

        public DefaultLocationPart(String partPath, Optional<TypedComponentIdentifier> partIdentifier, Optional<String> fileName, OptionalInt lineInFile, OptionalInt startColumn) {
            this.partPath = partPath;
            this.partIdentifier = partIdentifier.orElse(null);
            fileName.ifPresent(configFileName -> {
                this.fileName = configFileName;
            });
            lineInFile.ifPresent(line -> {
                this.lineInFile = line;
            });
            startColumn.ifPresent(column -> {
                this.startColumn = column;
            });
        }

        @Deprecated
        public DefaultLocationPart(String partPath, Optional<TypedComponentIdentifier> partIdentifier, Optional<String> fileName, Optional<Integer> lineInFile, Optional<Integer> startColumn) {
            this.partPath = partPath;
            this.partIdentifier = partIdentifier.orElse(null);
            fileName.ifPresent(configFileName -> {
                this.fileName = configFileName;
            });
            lineInFile.ifPresent(line -> {
                this.lineInFile = line;
            });
            startColumn.ifPresent(column -> {
                this.startColumn = column;
            });
        }

        public String getPartPath() {
            return this.partPath;
        }

        public Optional<TypedComponentIdentifier> getPartIdentifier() {
            return Optional.ofNullable(this.partIdentifier);
        }

        public Optional<String> getFileName() {
            return Optional.ofNullable(this.fileName);
        }

        public Optional<Integer> getLineInFile() {
            return this.lineInFile == -1 ? Optional.empty() : Optional.ofNullable(this.lineInFile);
        }

        public OptionalInt getLine() {
            return this.lineInFile == -1 ? OptionalInt.empty() : OptionalInt.of(this.lineInFile);
        }

        public Optional<Integer> getStartColumn() {
            return this.startColumn == -1 ? Optional.empty() : Optional.ofNullable(this.startColumn);
        }

        public OptionalInt getColumn() {
            return this.startColumn == -1 ? OptionalInt.empty() : OptionalInt.of(this.startColumn);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultLocationPart that = (DefaultLocationPart)o;
            if (this.lineInFile != that.lineInFile) {
                return false;
            }
            if (this.startColumn != that.startColumn) {
                return false;
            }
            if (!Objects.equals(this.partPath, that.partPath)) {
                return false;
            }
            if (this.partIdentifier != null ? !this.partIdentifier.equals(that.partIdentifier) : that.partIdentifier != null) {
                return false;
            }
            return this.fileName != null ? this.fileName.equals(that.fileName) : that.fileName == null;
        }

        public int hashCode() {
            int result = this.partPath != null ? this.partPath.hashCode() : 31;
            result = 31 * result + (this.partIdentifier != null ? this.partIdentifier.hashCode() : 0);
            result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
            result = 31 * result + (this.lineInFile != -1 ? this.lineInFile : 0);
            result = 31 * result + (this.startColumn != -1 ? this.startColumn : 0);
            return result;
        }

        public String toString() {
            return "DefaultLocationPart{partPath='" + this.partPath + '\'' + ", partIdentifier=" + this.partIdentifier + ", fileName='" + this.fileName + '\'' + ", lineInFile=" + this.lineInFile + ", startColumn=" + this.startColumn + '}';
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
            oos.writeObject(this.lineInFile != -1 ? null : Integer.valueOf(this.lineInFile));
            oos.writeObject(this.startColumn != -1 ? null : Integer.valueOf(this.startColumn));
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            Integer readLine = (Integer)ois.readObject();
            this.lineInFile = readLine != null ? readLine : -1;
            Integer readColumn = (Integer)ois.readObject();
            this.startColumn = readColumn != null ? readColumn : -1;
        }
    }
}

