/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.streaming.object;

import com.mulesoft.mule.runtime.core.internal.streaming.object.FileStoreCursorIteratorConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.internal.streaming.TempBufferFileUtils;
import org.mule.runtime.core.internal.streaming.object.AbstractObjectStreamBuffer;
import org.mule.runtime.core.internal.streaming.object.Bucket;
import org.mule.runtime.core.internal.streaming.object.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreObjectStreamBuffer<T>
extends AbstractObjectStreamBuffer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileStoreObjectStreamBuffer.class);
    private final int bucketSize;
    private final ObjectSerializer objectSerializer;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private List<File> persistedBuckets = new ArrayList<File>();

    public FileStoreObjectStreamBuffer(Iterator<T> stream, FileStoreCursorIteratorConfig config, ObjectSerializer objectSerializer) {
        super(stream);
        this.objectSerializer = objectSerializer;
        this.bucketSize = config.getMaxInMemoryInstances();
    }

    protected void initialize(Optional<Position> maxPosition, Bucket<T> initialBucket) {
        this.persistedBuckets = maxPosition.map(p -> new ArrayList(p.getBucketIndex())).orElseGet(ArrayList::new);
        this.setCurrentBucket(new Bucket(0, this.bucketSize));
    }

    public Position toPosition(long position) {
        if (position < (long)this.bucketSize) {
            return new Position(0, (int)position);
        }
        int bucketIndex = (int)Math.floor(position / (long)this.bucketSize);
        int itemIndex = (int)position - this.bucketSize * bucketIndex;
        return new Position(bucketIndex, itemIndex);
    }

    protected Bucket<T> getPresentBucket(Position position) {
        File bucketFile;
        block16: {
            int bucketIndex = position.getBucketIndex();
            if (bucketIndex == this.getCurrentBucket().getIndex()) {
                return this.getCurrentBucket();
            }
            this.readLock.lock();
            try {
                if (bucketIndex < this.persistedBuckets.size()) {
                    bucketFile = this.persistedBuckets.get(bucketIndex);
                    break block16;
                }
                return null;
            }
            finally {
                this.readLock.unlock();
            }
        }
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (FileInputStream in = FileUtils.openInputStream((File)bucketFile);){
                return (Bucket)this.objectSerializer.getInternalProtocol().deserialize((InputStream)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not load persisted bucket"), (Throwable)e);
        }
    }

    protected void validateMaxBufferSizeNotExceeded(int instancesCount) {
    }

    protected Bucket<T> onBucketOverflow(Bucket<T> overflownBucket) {
        int index = overflownBucket.getIndex();
        File bucketFile = TempBufferFileUtils.createBufferFile((String)String.valueOf(index));
        this.writeLock.lock();
        try {
            this.persistedBuckets.add(bucketFile);
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            FileUtils.writeByteArrayToFile((File)bucketFile, (byte[])this.objectSerializer.getInternalProtocol().serialize(overflownBucket));
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not store bucket into disk"), (Throwable)e);
        }
        return new Bucket(index + 1, this.bucketSize);
    }

    public void doClose() {
        if (!this.persistedBuckets.isEmpty()) {
            this.persistedBuckets.forEach(f -> {
                block2: {
                    try {
                        Files.delete(f.toPath());
                    }
                    catch (Exception e) {
                        if (!LOGGER.isWarnEnabled()) break block2;
                        LOGGER.warn("Found exception trying to delete temporal streaming file " + f.getAbsolutePath(), (Throwable)e);
                    }
                }
            });
            this.persistedBuckets.clear();
        }
    }
}

