/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.streaming.bytes;

import com.mulesoft.mule.runtime.core.internal.streaming.bytes.FileStoreInputStreamBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.mule.runtime.api.streaming.bytes.ImmutableFileRepeatableInputStream;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.FileStoreCursorStreamConfig;

public class ImmutableFileStoreInputStreamBuffer
extends FileStoreInputStreamBuffer {
    public ImmutableFileStoreInputStreamBuffer(ImmutableFileRepeatableInputStream stream, FileStoreCursorStreamConfig config, ByteBufferManager bufferManager) {
        super((InputStream)stream, config, bufferManager);
    }

    @Override
    protected LazyValue<Pair<File, RandomAccessFile>> createFileStore() {
        ImmutableFileRepeatableInputStream stream = (ImmutableFileRepeatableInputStream)this.stream;
        File file = stream.getFile();
        try {
            return new LazyValue((Object)new Pair((Object)file, (Object)new RandomAccessFile(file, "r")));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("Stream file '%s' does not exists. Verify it wasn't deleted by some other process", file.getAbsolutePath()), e);
        }
    }

    @Override
    protected void write(RandomAccessFile fileStore, ByteBuffer b, int len) throws IOException {
    }

    @Override
    protected void deleteBufferFile(File bufferFile) {
    }
}

