/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import org.raml.v2.internal.utils.RamlTreeNodeDumper;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.util.NodeAppender;

public class Dumper {
    public static String inMemoryDumper(Node raml) {
        StringWriter sw = new StringWriter();
        RamlTreeNodeDumper dumper = new RamlTreeNodeDumper(sw);
        dumper.dump(raml);
        return sw.toString().trim();
    }

    public static void straightOutput(Node raml) {
        final OutputStreamWriter writer = new OutputStreamWriter(System.out);
        RamlTreeNodeDumper dumper = new RamlTreeNodeDumper(new NodeAppender(){

            public NodeAppender append(Object o) {
                try {
                    writer.append(o.toString());
                    writer.flush();
                    return this;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public NodeAppender append(String s) {
                try {
                    writer.append(s);
                    writer.flush();
                    return this;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public NodeAppender append(int s) {
                try {
                    writer.append(Integer.toString(s));
                    writer.flush();
                    return this;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public NodeAppender dump() {
                return this;
            }
        });
        dumper.dump(raml);
    }
}

