/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.mule.apache.xerces.impl.dtd.models.CMNode;
import org.mule.apache.xerces.impl.dtd.models.CMStateSet;
import org.mule.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.mule.apache.xerces.impl.xs.XMLSchemaException;
import org.mule.apache.xerces.impl.xs.XSConstraints;
import org.mule.apache.xerces.impl.xs.XSElementDecl;
import org.mule.apache.xerces.impl.xs.XSElementDeclHelper;
import org.mule.apache.xerces.impl.xs.XSOpenContentDecl;
import org.mule.apache.xerces.impl.xs.XSWildcardDecl;
import org.mule.apache.xerces.impl.xs.models.XS11AllCM;
import org.mule.apache.xerces.impl.xs.models.XS11CMRestriction;
import org.mule.apache.xerces.impl.xs.models.XSCMBinOp;
import org.mule.apache.xerces.impl.xs.models.XSCMLeaf;
import org.mule.apache.xerces.impl.xs.models.XSCMRepeatingLeaf;
import org.mule.apache.xerces.impl.xs.models.XSCMUniOp;
import org.mule.apache.xerces.impl.xs.models.XSCMValidator;
import org.mule.apache.xerces.xni.QName;
import org.mule.apache.xerces.xs.XSTerm;

public class XSDFACM
implements XSCMValidator,
XS11CMRestriction.XS11CM {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private XSElementDecl[] fElements;
    private XSWildcardDecl[] fWildcards;
    private int fNumElements;
    private int fNumTotal;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private XSCMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private final XSOpenContentDecl fOpenContent;
    private final short fSchemaVersion;
    private Occurence[] fCountingStates = null;
    private int fTransTableSize = 0;
    private boolean fIsCompactedForUPA;
    private static long time = 0L;

    public XSDFACM(CMNode syntaxTree, int leafCount, short schemaVersion, XSOpenContentDecl openContent) {
        this.fLeafCount = leafCount;
        this.fIsCompactedForUPA = syntaxTree.isCompactedForUPA();
        this.fSchemaVersion = schemaVersion;
        this.fOpenContent = openContent;
        this.buildDFA(syntaxTree);
    }

    public boolean isFinalState(int state) {
        return state < 0 ? false : this.fFinalStateFlags[state];
    }

    @Override
    public Object oneTransition(QName curElem, int[] state, SubstitutionGroupHandler subGroupHandler, XSElementDeclHelper eDeclHelper) {
        Object ret = this.oneTransition1(curElem, state, subGroupHandler, eDeclHelper);
        if (this.fOpenContent != null && ret == this.fOpenContent.fWildcard) {
            ret = this.fOpenContent;
        }
        return ret;
    }

    private Object oneTransition1(QName curElem, int[] state, SubstitutionGroupHandler subGroupHandler, XSElementDeclHelper eDeclHelper) {
        int elemIndex;
        int curState = state[0];
        if (curState == -1 || curState == -2) {
            if (curState == -1) {
                state[0] = -2;
            }
            return this.findMatchingDecl(curElem, subGroupHandler);
        }
        int nextState = 0;
        XSTerm matchingDecl = null;
        for (elemIndex = 0; elemIndex < this.fNumElements && ((nextState = this.fTransTable[curState][elemIndex]) == -1 || (matchingDecl = subGroupHandler.getMatchingElemDecl(curElem, this.fElements[elemIndex], this.fSchemaVersion)) == null); ++elemIndex) {
        }
        if (matchingDecl == null) {
            while (elemIndex < this.fNumTotal) {
                nextState = this.fTransTable[curState][elemIndex];
                if (nextState != -1) {
                    if (this.fSchemaVersion < 4) {
                        if (this.fWildcards[elemIndex].allowNamespace(curElem.uri)) {
                            matchingDecl = this.fWildcards[elemIndex];
                            break;
                        }
                    } else if (this.allowExpandedName(this.fWildcards[elemIndex], curElem, subGroupHandler, eDeclHelper)) {
                        matchingDecl = this.fWildcards[elemIndex];
                        break;
                    }
                }
                ++elemIndex;
            }
        }
        if (matchingDecl == null) {
            state[1] = state[0];
            state[0] = -1;
            return this.findMatchingDecl(curElem, subGroupHandler);
        }
        state[0] = nextState;
        if (this.fCountingStates == null) {
            return matchingDecl;
        }
        if (this.fOpenContent != null && this.fOpenContent.fWildcard == matchingDecl && this.fOpenContent.fMode == 1) {
            return matchingDecl;
        }
        Occurence o = this.fCountingStates[curState];
        if (o != null) {
            if (curState == nextState) {
                state[2] = state[2] + 1;
                if (state[2] > o.maxOccurs && o.maxOccurs != -1) {
                    return this.findMatchingDecl(curElem, state, subGroupHandler, ++elemIndex, eDeclHelper);
                }
            } else {
                if (state[2] < o.minOccurs) {
                    state[1] = state[0];
                    state[0] = -1;
                    return this.findMatchingDecl(curElem, subGroupHandler);
                }
                o = this.fCountingStates[nextState];
                if (o != null) {
                    state[2] = elemIndex == o.elemIndex ? 1 : 0;
                }
            }
        } else {
            o = this.fCountingStates[nextState];
            if (o != null) {
                state[2] = elemIndex == o.elemIndex ? 1 : 0;
            }
        }
        return matchingDecl;
    }

    Object findMatchingDecl(QName curElem, SubstitutionGroupHandler subGroupHandler) {
        int elemIndex;
        XSElementDecl matchingDecl = null;
        for (elemIndex = 0; elemIndex < this.fNumElements; ++elemIndex) {
            matchingDecl = subGroupHandler.getMatchingElemDecl(curElem, this.fElements[elemIndex], this.fSchemaVersion);
            if (matchingDecl == null) continue;
            return matchingDecl;
        }
        for (elemIndex = this.fNumElements; elemIndex < this.fNumTotal; ++elemIndex) {
            if (!this.fWildcards[elemIndex].allowQName(curElem)) continue;
            return this.fWildcards[elemIndex];
        }
        return null;
    }

    Object findMatchingDecl(QName curElem, int[] state, SubstitutionGroupHandler subGroupHandler, int elemIndex, XSElementDeclHelper eDeclHelper) {
        int curState = state[0];
        int nextState = 0;
        XSTerm matchingDecl = null;
        while (elemIndex < this.fNumElements && ((nextState = this.fTransTable[curState][elemIndex]) == -1 || (matchingDecl = subGroupHandler.getMatchingElemDecl(curElem, this.fElements[elemIndex], this.fSchemaVersion)) == null)) {
            ++elemIndex;
        }
        if (matchingDecl == null) {
            while (elemIndex < this.fNumTotal) {
                if (this.fSchemaVersion < 4) {
                    if (this.fWildcards[elemIndex].allowNamespace(curElem.uri)) {
                        matchingDecl = this.fWildcards[elemIndex];
                        break;
                    }
                } else if (this.allowExpandedName(this.fWildcards[elemIndex], curElem, subGroupHandler, eDeclHelper)) {
                    matchingDecl = this.fWildcards[elemIndex];
                    break;
                }
                ++elemIndex;
            }
        }
        if (matchingDecl == null) {
            state[1] = state[0];
            state[0] = -1;
            return this.findMatchingDecl(curElem, subGroupHandler);
        }
        state[0] = nextState;
        Occurence o = this.fCountingStates[nextState];
        if (o != null) {
            state[2] = elemIndex == o.elemIndex ? 1 : 0;
        }
        return matchingDecl;
    }

    @Override
    public XSElementDecl findMatchingElemDecl(QName curElem, SubstitutionGroupHandler subGroupHandler) {
        XSElementDecl matchingDecl = null;
        for (int elemIndex = 0; elemIndex < this.fNumElements; ++elemIndex) {
            matchingDecl = subGroupHandler.getMatchingElemDecl(curElem, this.fElements[elemIndex], this.fSchemaVersion);
            if (matchingDecl == null) continue;
            return matchingDecl;
        }
        return null;
    }

    @Override
    public boolean allowExpandedName(XSWildcardDecl wildcard, QName curElem, SubstitutionGroupHandler subGroupHandler, XSElementDeclHelper eDeclHelper) {
        if (wildcard.allowQName(curElem)) {
            if (wildcard.fDisallowedSibling && this.findMatchingElemDecl(curElem, subGroupHandler) != null) {
                return false;
            }
            return !wildcard.fDisallowedDefined || eDeclHelper.getGlobalElementDecl(curElem) == null;
        }
        return false;
    }

    @Override
    public int[] startContentModel() {
        return new int[3];
    }

    @Override
    public boolean endContentModel(int[] state) {
        int curState = state[0];
        if (this.fFinalStateFlags[curState]) {
            Occurence o;
            return this.fCountingStates == null || (o = this.fCountingStates[curState]) == null || state[2] >= o.minOccurs;
        }
        return false;
    }

    private void buildDFA(CMNode syntaxTree) {
        int i;
        int EOCPos = this.fLeafCount;
        XSCMLeaf nodeEOC = new XSCMLeaf(1, null, -1, this.fLeafCount++);
        this.fHeadNode = new XSCMBinOp(102, syntaxTree, nodeEOC);
        this.fLeafList = new XSCMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        for (int index = 0; index < this.fLeafCount; ++index) {
            this.fFollowList[index] = new CMStateSet(this.fLeafCount);
        }
        this.calcFollowList(this.fHeadNode);
        Object[] fElemMap = new Object[this.fLeafCount];
        int[] fElemMapType = new int[this.fLeafCount];
        int[] fElemMapId = new int[this.fLeafCount];
        int fElemMapSize = 0;
        Occurence[] elemOccurenceMap = null;
        int numElem = 0;
        for (int outIndex = 0; outIndex < this.fLeafCount; ++outIndex) {
            int inIndex;
            fElemMap[outIndex] = null;
            int id = this.fLeafList[outIndex].getParticleId();
            for (inIndex = 0; inIndex < fElemMapSize && id != fElemMapId[inIndex]; ++inIndex) {
            }
            if (inIndex != fElemMapSize) continue;
            XSCMLeaf leaf = this.fLeafList[outIndex];
            fElemMap[fElemMapSize] = leaf.getLeaf();
            if (leaf instanceof XSCMRepeatingLeaf) {
                if (elemOccurenceMap == null) {
                    elemOccurenceMap = new Occurence[this.fLeafCount];
                }
                elemOccurenceMap[fElemMapSize] = new Occurence((XSCMRepeatingLeaf)leaf, fElemMapSize);
            }
            fElemMapType[fElemMapSize] = this.fLeafListType[outIndex];
            fElemMapId[fElemMapSize] = id;
            if (fElemMapType[fElemMapSize] == 1) {
                ++numElem;
            }
            ++fElemMapSize;
        }
        --numElem;
        this.fNumTotal = --fElemMapSize;
        if (this.fOpenContent != null) {
            ++this.fNumTotal;
        }
        int ep = 0;
        int wp = fElemMapSize - 1;
        while (true) {
            if (ep <= wp && fElemMapType[ep] == 1) {
                ++ep;
                continue;
            }
            while (wp >= ep && fElemMapType[wp] == 2) {
                --wp;
            }
            if (ep >= wp) break;
            Object t1 = fElemMap[ep];
            fElemMap[ep] = fElemMap[wp];
            fElemMap[wp] = t1;
            int t2 = fElemMapId[ep];
            fElemMapId[ep] = fElemMapId[wp];
            fElemMapId[wp] = t2;
            if (elemOccurenceMap != null) {
                Occurence t3 = elemOccurenceMap[ep];
                elemOccurenceMap[ep] = elemOccurenceMap[wp];
                elemOccurenceMap[wp] = t3;
                if (elemOccurenceMap[ep] != null) {
                    elemOccurenceMap[ep].elemIndex = ep;
                }
                if (elemOccurenceMap[wp] != null) {
                    elemOccurenceMap[wp].elemIndex = wp;
                }
            }
            ++ep;
            --wp;
        }
        int[] fLeafSorter = new int[this.fLeafCount + fElemMapSize];
        int fSortCount = 0;
        for (int elemIndex = 0; elemIndex < fElemMapSize; ++elemIndex) {
            int id = fElemMapId[elemIndex];
            for (int leafIndex = 0; leafIndex < this.fLeafCount; ++leafIndex) {
                if (id != this.fLeafList[leafIndex].getParticleId()) continue;
                fLeafSorter[fSortCount++] = leafIndex;
            }
            fLeafSorter[fSortCount++] = -1;
        }
        int curArraySize = this.fLeafCount * 4;
        CMStateSet[] statesToDo = new CMStateSet[curArraySize];
        this.fFinalStateFlags = new boolean[curArraySize];
        this.fTransTable = new int[curArraySize][];
        CMStateSet setT = this.fHeadNode.firstPos();
        int unmarkedState = 0;
        int curState = 0;
        this.fTransTable[curState] = this.makeDefStateList();
        statesToDo[curState] = setT;
        ++curState;
        HashMap<CMStateSet, Integer> stateTable = new HashMap<CMStateSet, Integer>();
        while (unmarkedState < curState) {
            setT = statesToDo[unmarkedState];
            int[] transEntry = this.fTransTable[unmarkedState];
            this.fFinalStateFlags[unmarkedState] = setT.getBit(EOCPos);
            ++unmarkedState;
            CMStateSet newSet = null;
            int sorterIndex = 0;
            for (int elemIndex = 0; elemIndex < fElemMapSize; ++elemIndex) {
                int stateIndex;
                if (newSet == null) {
                    newSet = new CMStateSet(this.fLeafCount);
                } else {
                    newSet.zeroBits();
                }
                int leafIndex = fLeafSorter[sorterIndex++];
                while (leafIndex != -1) {
                    if (setT.getBit(leafIndex)) {
                        newSet.union(this.fFollowList[leafIndex]);
                    }
                    leafIndex = fLeafSorter[sorterIndex++];
                }
                if (newSet.isEmpty()) continue;
                Integer stateObj = (Integer)stateTable.get(newSet);
                int n = stateIndex = stateObj == null ? curState : stateObj;
                if (stateIndex == curState) {
                    statesToDo[curState] = newSet;
                    this.fTransTable[curState] = this.makeDefStateList();
                    stateTable.put(newSet, new Integer(curState));
                    ++curState;
                    newSet = null;
                }
                transEntry[elemIndex] = stateIndex;
                if (curState != curArraySize) continue;
                int newSize = (int)((double)curArraySize * 1.5);
                CMStateSet[] newToDo = new CMStateSet[newSize];
                boolean[] newFinalFlags = new boolean[newSize];
                int[][] newTransTable = new int[newSize][];
                System.arraycopy(statesToDo, 0, newToDo, 0, curArraySize);
                System.arraycopy(this.fFinalStateFlags, 0, newFinalFlags, 0, curArraySize);
                System.arraycopy(this.fTransTable, 0, newTransTable, 0, curArraySize);
                curArraySize = newSize;
                statesToDo = newToDo;
                this.fFinalStateFlags = newFinalFlags;
                this.fTransTable = newTransTable;
            }
        }
        if (elemOccurenceMap != null) {
            this.fCountingStates = new Occurence[curState];
            block10: for (int i2 = 0; i2 < curState; ++i2) {
                int[] transitions = this.fTransTable[i2];
                for (int j = 0; j < transitions.length; ++j) {
                    if (i2 != transitions[j]) continue;
                    this.fCountingStates[i2] = elemOccurenceMap[j];
                    continue block10;
                }
            }
        }
        this.fTransTableSize = curState;
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
        this.fLeafListType = null;
        fElemMapId = null;
        if (this.fOpenContent != null) {
            int i3;
            fElemMap[fElemMapSize] = this.fOpenContent.fWildcard;
            if (this.fOpenContent.fMode == 1) {
                for (i3 = 0; i3 < this.fTransTableSize; ++i3) {
                    this.fTransTable[i3][fElemMapSize] = i3;
                }
            } else {
                for (i3 = 0; i3 < this.fTransTableSize; ++i3) {
                    if (!this.fFinalStateFlags[i3]) continue;
                    this.fTransTable[i3][fElemMapSize] = this.fTransTableSize;
                }
                this.fTransTable[this.fTransTableSize] = this.makeDefStateList();
                this.fTransTable[this.fTransTableSize][fElemMapSize] = this.fTransTableSize;
                this.fFinalStateFlags[this.fTransTableSize] = true;
                ++this.fTransTableSize;
            }
            ++fElemMapSize;
        }
        this.fNumElements = numElem;
        if (numElem > 0) {
            this.fElements = new XSElementDecl[numElem];
        }
        if (this.fNumTotal > numElem) {
            this.fWildcards = new XSWildcardDecl[this.fNumTotal];
        }
        for (i = 0; i < numElem; ++i) {
            this.fElements[i] = (XSElementDecl)fElemMap[i];
        }
        for (i = numElem; i < this.fNumTotal; ++i) {
            this.fWildcards[i] = (XSWildcardDecl)fElemMap[i];
        }
    }

    private void calcFollowList(CMNode nodeCur) {
        if (nodeCur.type() == 101) {
            this.calcFollowList(((XSCMBinOp)nodeCur).getLeft());
            this.calcFollowList(((XSCMBinOp)nodeCur).getRight());
        } else if (nodeCur.type() == 102) {
            this.calcFollowList(((XSCMBinOp)nodeCur).getLeft());
            this.calcFollowList(((XSCMBinOp)nodeCur).getRight());
            CMStateSet last = ((XSCMBinOp)nodeCur).getLeft().lastPos();
            CMStateSet first = ((XSCMBinOp)nodeCur).getRight().firstPos();
            for (int index = 0; index < this.fLeafCount; ++index) {
                if (!last.getBit(index)) continue;
                this.fFollowList[index].union(first);
            }
        } else if (nodeCur.type() == 4 || nodeCur.type() == 6) {
            this.calcFollowList(((XSCMUniOp)nodeCur).getChild());
            CMStateSet first = nodeCur.firstPos();
            CMStateSet last = nodeCur.lastPos();
            for (int index = 0; index < this.fLeafCount; ++index) {
                if (!last.getBit(index)) continue;
                this.fFollowList[index].union(first);
            }
        } else if (nodeCur.type() == 5) {
            this.calcFollowList(((XSCMUniOp)nodeCur).getChild());
        }
    }

    private void dumpTree(CMNode nodeCur, int level) {
        for (int index = 0; index < level; ++index) {
            System.out.print("   ");
        }
        int type = nodeCur.type();
        switch (type) {
            case 101: 
            case 102: {
                if (type == 101) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (nodeCur.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                this.dumpTree(((XSCMBinOp)nodeCur).getLeft(), level + 1);
                this.dumpTree(((XSCMBinOp)nodeCur).getRight(), level + 1);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                System.out.print("Rep Node ");
                if (nodeCur.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                this.dumpTree(((XSCMUniOp)nodeCur).getChild(), level + 1);
                break;
            }
            case 1: {
                System.out.print("Leaf: (pos=" + ((XSCMLeaf)nodeCur).getPosition() + "), " + "(elemIndex=" + ((XSCMLeaf)nodeCur).getLeaf() + ") ");
                if (nodeCur.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                break;
            }
            case 2: {
                System.out.print("Any Node: ");
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_NIICM");
            }
        }
    }

    private int[] makeDefStateList() {
        int[] retArray = new int[this.fNumTotal];
        for (int index = 0; index < this.fNumTotal; ++index) {
            retArray[index] = -1;
        }
        return retArray;
    }

    private void postTreeBuildInit(CMNode nodeCur) throws RuntimeException {
        nodeCur.setMaxStates(this.fLeafCount);
        XSCMLeaf leaf = null;
        int pos = 0;
        if (nodeCur.type() == 2) {
            leaf = (XSCMLeaf)nodeCur;
            pos = leaf.getPosition();
            this.fLeafList[pos] = leaf;
            this.fLeafListType[pos] = 2;
        } else if (nodeCur.type() == 101 || nodeCur.type() == 102) {
            this.postTreeBuildInit(((XSCMBinOp)nodeCur).getLeft());
            this.postTreeBuildInit(((XSCMBinOp)nodeCur).getRight());
        } else if (nodeCur.type() == 4 || nodeCur.type() == 6 || nodeCur.type() == 5) {
            this.postTreeBuildInit(((XSCMUniOp)nodeCur).getChild());
        } else if (nodeCur.type() == 1) {
            leaf = (XSCMLeaf)nodeCur;
            pos = leaf.getPosition();
            this.fLeafList[pos] = leaf;
            this.fLeafListType[pos] = 1;
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    @Override
    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler subGroupHandler, XSConstraints xsConstraints) throws XMLSchemaException {
        int j;
        int i;
        int elemSize = this.fOpenContent != null ? this.fNumTotal - 1 : this.fNumTotal;
        byte[][] conflictTable = new byte[elemSize][elemSize];
        for (i = 0; i < this.fTransTableSize; ++i) {
            for (j = 0; j < elemSize; ++j) {
                for (int k = j + 1; k < elemSize; ++k) {
                    if (this.fTransTable[i][j] == -1 || this.fTransTable[i][k] == -1 || conflictTable[j][k] != 0) continue;
                    if (xsConstraints.overlapUPA(j < this.fNumElements ? this.fElements[j] : this.fWildcards[j], k < this.fNumElements ? this.fElements[k] : this.fWildcards[k], subGroupHandler)) {
                        Occurence o;
                        if (this.fCountingStates != null && (o = this.fCountingStates[i]) != null && this.fTransTable[i][j] == i ^ this.fTransTable[i][k] == i && o.minOccurs == o.maxOccurs) {
                            conflictTable[j][k] = -1;
                            continue;
                        }
                        conflictTable[j][k] = 1;
                        continue;
                    }
                    conflictTable[j][k] = -1;
                }
            }
        }
        for (i = 0; i < elemSize; ++i) {
            for (j = 0; j < elemSize; ++j) {
                if (conflictTable[i][j] != 1) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{i < this.fNumElements ? this.fElements[i] : this.fWildcards[i], j < this.fNumElements ? this.fElements[j] : this.fWildcards[j]});
            }
        }
        for (i = this.fNumElements; i < elemSize; ++i) {
            XSWildcardDecl wildcard = this.fWildcards[i];
            if (wildcard.fType != 3 && wildcard.fType != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector whatCanGoHere(int[] state) {
        int elemSize = this.fOpenContent != null ? this.fNumTotal - 1 : this.fNumTotal;
        int curState = state[0];
        if (curState < 0) {
            curState = state[1];
        }
        Occurence o = this.fCountingStates != null ? this.fCountingStates[curState] : null;
        int count = state[2];
        Vector<XSElementDecl> ret = new Vector<XSElementDecl>();
        for (int elemIndex = 0; elemIndex < elemSize; ++elemIndex) {
            int nextState = this.fTransTable[curState][elemIndex];
            if (nextState == -1 || o != null && (curState != nextState ? count < o.minOccurs : count >= o.maxOccurs && o.maxOccurs != -1)) continue;
            ret.addElement((XSElementDecl)(elemIndex < this.fNumElements ? this.fElements[elemIndex] : this.fWildcards[elemIndex]));
        }
        return ret;
    }

    @Override
    public int[] occurenceInfo(int[] state) {
        if (this.fCountingStates != null) {
            Occurence o;
            int curState = state[0];
            if (curState < 0) {
                curState = state[1];
            }
            if ((o = this.fCountingStates[curState]) != null) {
                int[] occurenceInfo = new int[]{o.minOccurs, o.maxOccurs, state[2], o.elemIndex};
                return occurenceInfo;
            }
        }
        return null;
    }

    @Override
    public String getTermName(int termId) {
        XSTerm term = termId < this.fNumElements ? this.fElements[termId] : this.fWildcards[termId];
        return term != null ? term.toString() : null;
    }

    @Override
    public boolean isCompactedForUPA() {
        return this.fIsCompactedForUPA;
    }

    @Override
    public XSElementDecl nextElementTransition(int[] s, int[] sn, int[] index) {
        for (int idx = index[0] + 1; idx < this.fNumElements; ++idx) {
            if (!this.isAllowedTransition(s, sn, idx)) continue;
            index[0] = idx;
            return this.fElements[idx];
        }
        index[0] = -1;
        return null;
    }

    @Override
    public XSWildcardDecl nextWildcardTransition(int[] s, int[] sn, int[] index) {
        int idx;
        int n = idx = index[0] == -1 ? this.fNumElements : index[0] + 1;
        while (idx < this.fNumTotal) {
            if (this.isAllowedTransition(s, sn, idx)) {
                index[0] = idx;
                return this.fWildcards[idx];
            }
            ++idx;
        }
        index[0] = -1;
        return null;
    }

    private boolean isAllowedTransition(int[] s, int[] sn, int index) {
        int n = this.fTransTable[s[0]][index];
        if (n == -1) {
            return false;
        }
        if (sn != null) {
            sn[0] = n;
        }
        if (this.fCountingStates == null) {
            return true;
        }
        if (index == this.fNumTotal - 1 && this.fOpenContent != null && this.fOpenContent.fMode == 1) {
            return true;
        }
        Occurence o = this.fCountingStates[s[0]];
        if (o != null) {
            if (s[0] == n) {
                if (s[2] == o.maxOccurs) {
                    return false;
                }
                if (sn != null) {
                    sn[2] = s[2];
                    if (sn[2] == 0 || sn[2] < o.minOccurs || o.maxOccurs != -1) {
                        sn[2] = sn[2] + 1;
                    }
                }
            } else {
                if (s[2] < o.minOccurs) {
                    return false;
                }
                o = this.fCountingStates[n];
                if (o != null && sn != null) {
                    sn[2] = index == o.elemIndex ? 1 : 0;
                }
            }
        } else {
            o = this.fCountingStates[n];
            if (o != null && sn != null) {
                sn[2] = index == o.elemIndex ? 1 : 0;
            }
        }
        return true;
    }

    @Override
    public boolean isOpenContent(XSWildcardDecl w) {
        return this.fOpenContent != null && this.fOpenContent.fWildcard == w;
    }

    @Override
    public List getDefinedNames(SubstitutionGroupHandler subGroupHandler) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < this.fNumElements; ++i) {
            XSElementDecl e = this.fElements[i];
            ret.add(e.fTargetNamespace);
            ret.add(e.fName);
            if (e.fScope != 1) continue;
            XSElementDecl[] es = subGroupHandler.getSubstitutionGroup(e, this.fSchemaVersion);
            for (int j = 0; j < es.length; ++j) {
                ret.add(es[j].fTargetNamespace);
                ret.add(es[j].fName);
            }
        }
        return ret;
    }

    @Override
    public void optimizeStates(XS11CMRestriction.XS11CM base, int[] b, int[] d, int indexb) {
        if (this.fCountingStates == null || this.fCountingStates[d[0]] == null) {
            return;
        }
        if (d[2] <= 0) {
            return;
        }
        int need = 0;
        if (d[2] < this.fCountingStates[d[0]].minOccurs) {
            need = this.fCountingStates[d[0]].minOccurs - d[2];
        } else if (d[2] > this.fCountingStates[d[0]].minOccurs && d[2] < this.fCountingStates[d[0]].maxOccurs) {
            need = this.fCountingStates[d[0]].maxOccurs - d[2];
        }
        if (need == 0) {
            return;
        }
        if (base instanceof XSDFACM) {
            this.optimizeForDFABase((XSDFACM)base, b, d, need);
        } else if (base instanceof XS11AllCM) {
            this.optimizeForAllBase((XS11AllCM)base, b, d, need, indexb);
        }
    }

    private void optimizeForDFABase(XSDFACM base, int[] b, int[] d, int need) {
        if (base.fCountingStates == null || base.fCountingStates[b[0]] == null) {
            return;
        }
        if (b[2] <= 0) {
            return;
        }
        if (base.fCountingStates[d[0]] != null) {
            if (base.fCountingStates[d[0]].maxOccurs == -1) {
                d[2] = d[2] + need;
                b[2] = b[2] + need > base.fCountingStates[d[0]].minOccurs ? base.fCountingStates[d[0]].minOccurs : b[2] + need;
            } else {
                if (need > base.fCountingStates[d[0]].maxOccurs - b[2]) {
                    need = base.fCountingStates[d[0]].maxOccurs - b[2];
                }
                b[2] = b[2] + need;
                d[2] = d[2] + need;
            }
        }
    }

    private void optimizeForAllBase(XS11AllCM base, int[] b, int[] d, int need, int indexb) {
        if (b[indexb] <= 0) {
            return;
        }
        if (base.maxOccurs(indexb) == -1) {
            d[2] = d[2] + need;
            if (b[indexb] + need > base.minOccurs(indexb)) {
                b[indexb] = base.minOccurs(indexb);
            } else {
                int n = indexb;
                b[n] = b[n] + need;
            }
        } else {
            if (need > base.maxOccurs(indexb) - b[indexb]) {
                need = base.maxOccurs(indexb) - b[indexb];
            }
            int n = indexb;
            b[n] = b[n] + need;
            d[2] = d[2] + need;
        }
    }

    static final class Occurence {
        final int minOccurs;
        final int maxOccurs;
        int elemIndex;

        public Occurence(XSCMRepeatingLeaf leaf, int elemIndex) {
            this.minOccurs = leaf.getMinOccurs();
            this.maxOccurs = leaf.getMaxOccurs();
            this.elemIndex = elemIndex;
        }

        public String toString() {
            return "minOccurs=" + this.minOccurs + ";maxOccurs=" + (this.maxOccurs != -1 ? Integer.toString(this.maxOccurs) : "unbounded");
        }
    }
}

