/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.reboot.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.security.Security;

public class FipsSecurityManager {
    private static final String FIPS_KEY = "fips";
    private static final String FIPS_VALUE = "BCFIPS";
    private static final String FIPS_PROVIDER = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    private static final String FIPS_SECURITY_MODEL = "fips140-2";
    private static final String JSSE_PROVIDER = "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider";
    private static final String KEY_MANAGER_FACTORY_ALGORITHM_KEY = "ssl.KeyManagerFactory.algorithm";
    private static final String KEY_MANAGER_FACTORY_ALGORITHM_VALUE = "PKIX";
    private static final String KEYSTORE_TYPE_KEY = "keystore.type";
    private static final String KEYSTORE_TYPE_VALUE = "PKCS12";
    private static final String LEGACY_SUN_JSSE_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    private static final String TRUST_MANAGER_FACTORY_ALGORITHM_KEY = "ssl.KeyManagerFactory.algorithm";
    private static final String SUN_JSSE_PROVIDER = "SunJSSE";

    public void configureFips() throws Exception {
        this.configureSecurityManager();
        this.setSecurityAlgorithm();
    }

    public boolean isFipsEnabled() {
        return FIPS_SECURITY_MODEL.equals(System.getProperty("mule.security.model"));
    }

    private void configureSecurityManager() throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Class<?> classDef = Class.forName(FIPS_PROVIDER);
        Constructor<?> constructor = classDef.getConstructor(new Class[0]);
        Provider fipsProvider = (Provider)constructor.newInstance(new Object[0]);
        Security.insertProviderAt(fipsProvider, 1);
        classDef = Class.forName(JSSE_PROVIDER);
        constructor = classDef.getConstructor(new Class[0]);
        Provider jsseProvider = (Provider)constructor.newInstance(new Object[0]);
        jsseProvider.setProperty(FIPS_KEY, FIPS_VALUE);
        Security.insertProviderAt(jsseProvider, 2);
        Provider sunJsseProvider = Security.getProvider(SUN_JSSE_PROVIDER);
        Provider sunJsseProviderLegacy = Security.getProvider(LEGACY_SUN_JSSE_PROVIDER);
        if (sunJsseProvider != null) {
            Security.removeProvider(SUN_JSSE_PROVIDER);
        }
        if (sunJsseProviderLegacy != null) {
            sunJsseProviderLegacy.setProperty(FIPS_VALUE, "");
        }
    }

    private void setSecurityAlgorithm() {
        Security.setProperty("ssl.KeyManagerFactory.algorithm", KEY_MANAGER_FACTORY_ALGORITHM_VALUE);
        Security.setProperty("ssl.KeyManagerFactory.algorithm", KEY_MANAGER_FACTORY_ALGORITHM_VALUE);
        Security.setProperty(KEYSTORE_TYPE_KEY, KEYSTORE_TYPE_VALUE);
    }
}

